% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getBamInfo}
\alias{getBamInfo}
\title{Obtain library information from BAM files}
\usage{
getBamInfo(sample_info, yieldSize = NULL, cores = 1)
}
\arguments{
\item{sample_info}{Data frame with sample information including
mandatory columns \dQuote{sample_name} and \dQuote{file_bam}.
Column \dQuote{sample_name} must be a character vector. Column
\dQuote{file_bam} can be a character vector or \code{BamFileList}.}

\item{yieldSize}{Number of records used for obtaining library
information, or \code{NULL} for all records}

\item{cores}{Number of cores available for parallel processing}
}
\value{
\code{sample_info} with additional columns \dQuote{paired_end},
  \dQuote{read_length}, \dQuote{frag_length}, and \dQuote{lib_size}
  if \code{yieldSize} is \code{NULL}
}
\description{
Obtain paired-end status, median aligned read length,
median aligned insert size and library size from BAM files.
}
\details{
BAM files must have been generated with a splice-aware alignment
program that outputs the custom tag \sQuote{XS} for spliced reads,
indicating the direction of transcription. BAM files must be indexed.

Library information can be inferred from a subset of BAM records
by setting the number of records via argument \code{yieldSize}.
Note that library size is only obtained if \code{yieldSize} is {NULL}.
}
\examples{
path <- system.file("extdata", package = "SGSeq")
si$file_bam <- file.path(path, "bams", si$file_bam)

## data.frame as sample_info and character vector as file_bam
si <- si[, c("sample_name", "file_bam")]
si_complete <- getBamInfo(si)

## DataFrame as sample_info and BamFileList as file_bam
DF <- DataFrame(si)
DF$file_bam <- BamFileList(DF$file_bam)
DF_complete <- getBamInfo(DF)
}
\author{
Leonard Goldstein
}
