% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotRegionCounts}
\alias{plotRegionCounts}
\title{Visualize the raw read counts across regions or a user-defined genomic range}
\usage{
plotRegionCounts(SNPhood.o, regions = NULL, datasets = NULL,
  readGroups = NULL, mergeReadGroupCounts = FALSE, plotChr = NULL,
  plotStartPos = NULL, plotEndPos = NULL, ylim = NULL,
  plotRegionBoundaries = FALSE, plotRegionLabels = FALSE,
  maxWidthLabels = NULL, colorPalette = "Set1", sizePoints = 4,
  type = "p", printPlot = TRUE, fileToPlot = NULL, verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{regions}{Numeric or Character or NULL. Default NULL. Regions that should be plotted, either specified as integer (such as 1, value must be
between 1 and the total number of regions as defined in the object) or their annotation (name must appear in the region names as obtained via the function \code{annotationRegions}). If set to NULL, all regions will be considered.}

\item{datasets}{Numeric or Character or NULL. Default NULL. Datasets that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or their annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}). If set to NULL, all datasets will be considered.}

\item{readGroups}{Character or NULL. Default NULL. Read groups that should be plotted, specified by their name as obtained by the function \code{annotationReadGroups}). If set to NULL, all read groups will be considered.}

\item{mergeReadGroupCounts}{Logical(1). Default FALSE. Should the read groups be merged for visualization purposes?}

\item{plotChr}{Character(1) or NULL. Default NULL. The name of the chromosome for which the visualization should be done. Must be a valid chromosome name.
If set to NULL, other parameters (such as\code{regions}) determine which genomic region should be plotted.}

\item{plotStartPos}{Character(1) or NULL. Default NULL. The start coordinates for which the visualization should be done. Must be a valid number with respect to the chromosome it refers to. If set to NULL and the parameter \code{plotChr} is not NULL, the start coordinates are set to 1.}

\item{plotEndPos}{Character(1) or NULL. Default NULL. The end coordinates for which the visualization should be done. Must be a valid number with respect to the chromosome it refers to. If set to NULL and the parameter \code{plotChr} is not NULL, the end coordinates are determined automatically and the full chromosome will be plotted.}

\item{ylim}{Numeric(2). Default NULL. Range of the y-axis, as specified by a minimum and a maximum value. See ?ylim for details.}

\item{plotRegionBoundaries}{Logical(1). Default FALSE. Should the region boundaries be drawn in the plot? If set to TRUE, two vertical lines will be drawn for each region, corresponding to the region boundaries upstream and downstream of the SNP. This visual aid may help to judge the size of the regions and overlaps among regions.}

\item{plotRegionLabels}{Logical(1). Should the annotation of the regions be drawn vertically below the x axis? If many regions are plotted, 
labels may overlap; however, for a few regions, this is usually not a problem.}

\item{maxWidthLabels}{Numeric(1). Default NULL. Maximum width of the legend labels in number of characters. 
If the width of the legend labels are longer, they are shortened. Set to NULL to not shorten labels.}

\item{colorPalette}{Character(1). Default "Set1". Name of the palette from the \code{RColorBrewer} package from the qualitative palettes
for the colors of the datasets that are plotted. 
Allowed palette names are "Accent", "Dark2", "Paired", "Pastel1", "Pastel2", "Set1", "Set2", and "Set3". Colors for the datasets are
then determined automatically from the given palette name (from left to right, depending on the number of datasets to be plotted).
The colors for the read groups within each datasets are based on the colors for the dataset, but with different saturation values.}

\item{sizePoints}{Numeric(1). Default 4. Size of the points that are drawn in the plot (if type is set to the default value of "p"). 
This parameter has no effect if type is set to "l".}

\item{type}{Character(1). "p" or "l". Default "p". What type of plot should be drawn, points ("p") or lines ("l")?}

\item{printPlot}{Logical(1). Default TRUE. Should the plots be printed? Only relevant if \code{fileToPlot} is set to NULL; otherwise, the plots
are always printed to the output file.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
the generated \pkg{ggplot2} plot(s) as list for further processing. May contain multiple plots, depending on the function. The plot(s) can then be plotted individually or modified arbitrarily as the user wants. For example, if multiple plots are returned and the plots have been saved in a variable called plots.l, simply type plots.l[[1]] to view the first plot.
}
\description{
\code{plotBinCounts} visualizes the raw read counts (i.e., before binning user regions) across regions or a user-defined genomic range.
Note that only the results of a particular chromosome can be visualized. It is therefore only possible if the regions to be visualized 
are located on one particular chromosome; otherwise, an error is thrown.
}
\examples{
data(SNPhood.o, package="SNPhood")

# Plot the read counts for the first ten regions
plot = plotRegionCounts(SNPhood.o, regions = 1:10)

# Plot the read counts for the full chr21
plot = plotRegionCounts(SNPhood.o, plotChr = "chr21")

# Plot the read counts for the full chr21, merge read group counts and decrease the point size
plot = plotRegionCounts(SNPhood.o, plotChr = "chr21", sizePoints = 2, mergeReadGroupCounts = TRUE)
}

