% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{formatFromBismark}
\alias{formatFromBismark}
\title{Parsing output from the Bismark alignment suite}
\usage{
formatFromBismark(..., verbose = TRUE)
}
\arguments{
\item{...}{parameters from \code{bsseq::read.bismark()} function}

\item{verbose}{logical indicates the level of information provided by the
algorithm during the process. The default value is TRUE.}
}
\value{
This function returns a \code{list} of \code{data.frame}s (one per
chromosome). Each \code{data.frame} contains rows as individual CpGs
appearing in all the samples. The first 4 columns contain the information of
\code{Meth_Counts} (methylated counts), \code{Total_Counts} (read depths),
\code{Position} (Genomic position for the CpG site) and \code{ID} (sample ID).
The additional information (such as disease status, sex, age) extracted from
the BSseq object are listed in column 5 and onwards and will be considered
as covariate information by SOMNiBUS algorithms.
}
\description{
This function reads and converts Bismark's
\href{https://github.com/FelixKrueger/Bismark/tree/master/Docs#the-genome-wide-cytosine-report-optional-is-tab-delimited-in-the-following-format-1-based-coords}{'genome wide cytosine report'} and \href{https://github.com/FelixKrueger/Bismark/tree/master/Docs#the-coverage-output-looks-like-this-tab-delimited-1-based-genomic-coords}{'coverage'} into a
\code{list} of \code{data.frame}s (one per chromosome) to a format compatible
with SOMNiBUS' main functions \code{runSOMNiBUS} and
\code{binomRegMethModel}.
}
\examples{
infile <- system.file("extdata/test_data.fastq_bismark.bismark.cov.gz",
package = "bsseq")
dat <- formatFromBismark(infile, verbose = FALSE)
}
\seealso{
\link[bsseq]{read.bismark} for parsing output from the Bismark
alignment suite.

Other Parsing functions: 
\code{\link{formatFromBSseq}()}
}
\author{
Audrey Lemaçon
}
\concept{Parsing functions}
