% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_percentage_of_cells_within_radius.R
\name{average_percentage_of_cells_within_radius}
\alias{average_percentage_of_cells_within_radius}
\title{average_percentage_of_cells_within_radius}
\usage{
average_percentage_of_cells_within_radius(
  spe_object,
  reference_celltype,
  target_celltype,
  radius = 100,
  feature_colname
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_celltype}{String specifying the cell type of reference
cells.}

\item{target_celltype}{String specifying the cell type for target cells}

\item{radius}{Integer specifying the radius of search for cells around the
reference cells. Radii of ~100 are recommended. If too small, too few cells
might be present.}

\item{feature_colname}{String specifying the column with the desired cell
type annotations.}
}
\value{
A numeric vector and a plot are returned
}
\description{
Calculates the average percentage of cells of a target cell type
  within a radius from the cells with a reference cell type. The calculation
  is done per reference cell, so runtime will depend on the number of
  reference cells present. Output is a single value (the mean for the image).
}
\examples{
average_percentage_of_cells_within_radius(SPIAT::defined_image, "Tumour", 
"Immune3", radius = 100, "Cell.Type")
}
