% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_surface_plot.R
\name{marker_surface_plot}
\alias{marker_surface_plot}
\title{marker_surface_plot}
\usage{
marker_surface_plot(
  spe_object,
  num_splits,
  marker,
  x_position_min = NULL,
  x_position_max = NULL,
  y_position_min = NULL,
  y_position_max = NULL
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{num_splits}{Integer specifying the number of splits on the image,
higher splits equal to higher resolution. Recommendation: 10-100}

\item{marker}{Marker to plot}

\item{x_position_min}{Integer specifying the minimum x boundary to be
splitted}

\item{x_position_max}{Integer specifying the maximum x boundary to be
splitted}

\item{y_position_min}{Integer specifying the minimum y boundary to be
splitted}

\item{y_position_max}{Integer specifying the maximum y boundary to be
splitted}
}
\value{
A plot is returned
}
\description{
Generates a 3D surface plot of the level of the selected marker.
  Note that the image is blurred based on the 'num_splits' parameter.
}
\examples{
marker_surface_plot(SPIAT::simulated_image, num_splits=15, marker="Immune_marker1")
}
