% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_polymerase-class.R
\docType{class}
\name{SimulatePolymerase-class}
\alias{SimulatePolymerase-class}
\alias{simulatePolymerase}
\alias{sampleReadCounts}
\alias{sampleReadCounts,SimulatePolymerase-method}
\alias{show,SimulatePolymerase-method}
\alias{pauseSites}
\alias{pauseSites,SimulatePolymerase-method}
\alias{siteProbabilities}
\alias{siteProbabilities,SimulatePolymerase-method}
\alias{combinedCellsData}
\alias{combinedCellsData,SimulatePolymerase-method}
\alias{positionMatrices}
\alias{positionMatrices,SimulatePolymerase-method}
\alias{finalPositionMatrix}
\alias{finalPositionMatrix,SimulatePolymerase-method}
\alias{parameters}
\alias{parameters,SimulatePolymerase-method}
\alias{readCounts}
\alias{readCounts,SimulatePolymerase-method}
\alias{getPositionMatrixAtTime}
\alias{getPositionMatrixAtTime,SimulatePolymerase-method}
\alias{getAvailableTimePoints}
\alias{getAvailableTimePoints,SimulatePolymerase-method}
\alias{getCombinedCellsDataAtTime}
\alias{getCombinedCellsDataAtTime,SimulatePolymerase-method}
\alias{plotPauseSites}
\alias{plotPauseSites,SimulatePolymerase-method}
\alias{plotPositionHeatmap}
\alias{plotPositionHeatmap,SimulatePolymerase-method}
\alias{plotPolymerasePCA}
\alias{plotPolymerasePCA,SimulatePolymerase-method}
\alias{plotCombinedCells}
\alias{plotCombinedCells,SimulatePolymerase-method}
\title{Constructor for SimulatePolymerase object}
\usage{
simulatePolymerase(
  k = 50,
  ksd = 25,
  kMin = 17,
  kMax = 200,
  geneLen = 1950,
  alpha = 1,
  beta = 1,
  zeta = 2000,
  zetaSd = 1000,
  zetaMin = 1500,
  zetaMax = 2500,
  zetaVec = NULL,
  cellNum = 1000,
  polSize = 33,
  addSpace = 17,
  time = 1,
  timesToRecord = NULL
)

sampleReadCounts(object, readDensity = 0.0489)

\S4method{sampleReadCounts}{SimulatePolymerase}(object, readDensity = 0.0489)

\S4method{show}{SimulatePolymerase}(object)

pauseSites(object)

\S4method{pauseSites}{SimulatePolymerase}(object)

siteProbabilities(object)

\S4method{siteProbabilities}{SimulatePolymerase}(object)

combinedCellsData(object)

\S4method{combinedCellsData}{SimulatePolymerase}(object)

positionMatrices(object)

\S4method{positionMatrices}{SimulatePolymerase}(object)

finalPositionMatrix(object)

\S4method{finalPositionMatrix}{SimulatePolymerase}(object)

parameters(object)

\S4method{parameters}{SimulatePolymerase}(object)

readCounts(object)

\S4method{readCounts}{SimulatePolymerase}(object)

getPositionMatrixAtTime(object, timePoint)

\S4method{getPositionMatrixAtTime}{SimulatePolymerase}(object, timePoint)

getAvailableTimePoints(object)

\S4method{getAvailableTimePoints}{SimulatePolymerase}(object)

getCombinedCellsDataAtTime(object, timePoint = NULL)

\S4method{getCombinedCellsDataAtTime}{SimulatePolymerase}(object, timePoint = NULL)

plotPauseSites(object, file = NULL, width = 8, height = 6)

\S4method{plotPauseSites}{SimulatePolymerase}(object, file = NULL, width = 8, height = 6)

plotPositionHeatmap(
  object,
  timePoint = NULL,
  maxCells = NULL,
  file = NULL,
  width = 10,
  height = 8,
  dpi = 300
)

\S4method{plotPositionHeatmap}{SimulatePolymerase}(
  object,
  timePoint = NULL,
  maxCells = NULL,
  file = NULL,
  width = 10,
  height = 8,
  dpi = 300
)

plotPolymerasePCA(
  object,
  timePoint = NULL,
  file = NULL,
  width = 8,
  height = 6,
  dpi = 300
)

\S4method{plotPolymerasePCA}{SimulatePolymerase}(
  object,
  timePoint = NULL,
  file = NULL,
  width = 8,
  height = 6,
  dpi = 300
)

plotCombinedCells(
  object,
  start = NULL,
  end = NULL,
  timePoint = NULL,
  file = NULL
)

\S4method{plotCombinedCells}{SimulatePolymerase}(
  object,
  start = NULL,
  end = NULL,
  timePoint = NULL,
  file = NULL
)
}
\arguments{
\item{k}{an integer value for the mean of pause sites across cells.}

\item{ksd}{a numeric value for the standard deviation of pause sites across
cells.}

\item{kMin}{an integer value for the upper bound of pause sites allowed.}

\item{kMax}{an integer value for the lower bound of pause sites allowed.}

\item{geneLen}{an integer value for the length of the gene.}

\item{alpha}{a numeric value for the initiation rate.}

\item{beta}{a numeric value for the pause release rate.}

\item{zeta}{a numeric value for the mean elongation rate across sites.}

\item{zetaSd}{a numeric value for the standard deviation of pause sites
across sites.}

\item{zetaMin}{a numeric value for the minimum elongation rate.}

\item{zetaMax}{a numeric value for the maximum elongation rate.}

\item{zetaVec}{a character value for the path to the zetaVec file.}

\item{cellNum}{an integer value for the number of cells to simulate.}

\item{polSize}{an integer value for the polymerase II size.}

\item{addSpace}{an integer value for the additional space in addition to
RNAP size.}

\item{time}{a numeric value for the time to simulate.}

\item{timesToRecord}{a numeric vector of specific time points to record
position matrices for, or NULL to record no extra position matrices. Final
position matrix is always recorded. Default is NULL.}

\item{object}{A SimulatePolymerase-class object}

\item{readDensity}{A numeric value for the read density within gene body in
\emph{Dukler et al.} (2017) for genes with median expression (i.e., 0.0489).}

\item{timePoint}{Optional numeric value specifying the time point being
plotted (used for automatic title generation and documentation)}

\item{file}{Optional file path to save the plot to}

\item{width}{Plot width in inches}

\item{height}{Plot height in inches}

\item{maxCells}{Maximum number of cells to display (for performance with
large datasets). If NULL, shows all cells.}

\item{dpi}{Plot resolution in DPI}

\item{start}{Integer, starting position for plotting (default: NULL, uses
full range)}

\item{end}{Integer, ending position for plotting (default: NULL, uses full
range)}
}
\value{
a \code{SimulatePolymerase} object

The SimulatePolymerase object with read counts sampled given the
readDensity parameter used

A list containing all simulation parameters including k, ksd, kMin,
kMax, geneLen, alpha, beta, zeta, zetaSd, zetaMin, zetaMax, zetaVec, cellNum,
polSize, addSpace, time, and stepsToRecord

A 2D matrix of polymerase positions for the specified time point

A numeric vector of available time points

An integer vector representing the total number of polymerases at
each site across all cells for the specified time point

A ggplot object showing the distribution of pause sites

A ggplot object showing heatmap of polymerase positions

A ggplot object showing the PCA plot of cells

A ggplot object
}
\description{
Class \code{SimulatePolymerase} tracks the movement of RNAPs along the DNA
templates. It contains the parameters for the simulator as well as the
simulator results including the position of RNAPs for the last step, the
pause sites, a probability vector containing probability RNAPs move forward
or not, and a combined cells data vector containing the total number of
RNAPs at each site across all cells

Runs the simulator that tracks the movement of RNAPs along the DNA
templates of a large number of cells. It accepts several key user-specified
parameters, including the initiation rate, pause-escape rate, a constant or
variable elongation rate, the mean and variance of pause sites across cells,
as well as the center-to-center spacing constraint between RNAPs, the number
of cells being simulated, the gene length, and the total time of
transcription. The simulator simply allows each RNAP to move forward or not,
in time slices of 1e-4 minutes, according to the specified position-specific
rate parameters. It assumes that at most one movement of each RNAP can occur
per time slice. The simulator monitors for collisions between adjacent
RNAPs, prohibiting one RNAP to advance if it is at the boundary of the
allowable distance from the next. After running for specified time, it
outputs the position of RNAPs for the last specified number of steps.

Sample read counts from a SimulatePolymerase object. To match our simulated
read counts to reality, we need to compute a scaling factor lambda. One way
of doing it is computing the read density based on real experiments. For
example, we have computed the read density within gene body in
\emph{Dukler et al} (2017) for genes with median expression (i.e., 0.0489).
If we assume the read counts following a Poisson distribution, we can then
sample the read counts with mean equals to the RNAP frequency multiplied by
lambda.

Show method for SimulatePolymerase object in human readable format
including summary statistics

Accessor for the pause sites numeric vector from a SimulatePolymerase object.

Accessor for the probability numeric matrix from a SimulatePolymerase object.
The matrix has dimensions (sites x cells) where each element represents the
transition probability for a specific site and cell.

Accessor for the combined cells data numeric vector from a
SimulatePolymerase object.

Accessor for the position matrices from a SimulatePolymerase object.

Accessor for the final position matrix from a SimulatePolymerase object.
This represents the last state of the simulation.

Accessor for the simulation parameters from a SimulatePolymerase object.

Accessor for the read counts numeric vector sampled from a
SimulatePolymerase object.

Get the position matrix for a specific time point from a SimulatePolymerase
object.

Get all available time points from a SimulatePolymerase object.

Get the combined cells data vector for a specific time point from a
SimulatePolymerase object. This function calculates the total number of
polymerases at each site across all cells for the specified time point,
similar to the final combinedCellsData but for intermediate time points.

Plot the distribution of pause sites across the gene as a histogram.

Plot position matrices as a ggplot2 heatmap showing polymerase positions
across all cells at specific time points. Each cell in the heatmap
represents whether a polymerase is present (1) or absent (0) at a specific
site in a specific cell. By default, shows the final position matrix. Plots
for pause region which is from site 1 to  user-defined kMax.

Create a ggplot2 PCA plot of the polymerase position matrix, showing the
first two principal components for each cell. Useful for exploring
heterogeneity and clustering among cells. Useful for exploring the site
occupancy patterns for each cell.

Plot combined cells data as a ggplot2 plot. For SimulatePolymerase objects,
can plot data from specific time points by calculating combined cells data
from position matrices.
}
\section{Slots}{

\describe{
\item{\code{k}}{an integer value for the mean of pause sites across cells.}

\item{\code{ksd}}{a numeric value for the standard deviation of pause sites across
cells.}

\item{\code{kMin}}{an integer value for the upper bound of pause sites allowed.}

\item{\code{kMax}}{an integer value for the lower bound of pause sites allowed.}

\item{\code{geneLen}}{an integer value for the length of the gene.}

\item{\code{alpha}}{a numeric value for the initiation rate.}

\item{\code{beta}}{a numeric value for the pause release rate.}

\item{\code{zeta}}{a numeric value for the mean elongation rate across sites.}

\item{\code{zetaSd}}{a numeric value for the standard deviation of pause sites
across sites.}

\item{\code{zetaMin}}{a numeric value for the minimum elongation rate.}

\item{\code{zetaMax}}{a numeric value for the maximum elongation rate.}

\item{\code{zetaVec}}{a character value for the path to the zetaVec file.}

\item{\code{cellNum}}{an integer value for the number of cells to simulate.}

\item{\code{polSize}}{an integer value for the polymerase II size.}

\item{\code{addSpace}}{an integer value for the additional space in addition to
RNAP size.}

\item{\code{time}}{a numeric value for the time to simulate.}

\item{\code{timesToRecord}}{a numeric vector of specific time points to record
position matrices for, or NULL to record no extra position matrices. Final
position matrix is always recorded. Default is NULL.}

\item{\code{pauseSites}}{a numeric vector of pause sites}

\item{\code{siteProbabilities}}{a numeric matrix representing the probability that
the polymerase move forward or not at each site for each cell (sites x cells)}

\item{\code{combinedCellsData}}{an integer vector representing the total number of
RNAPs at each site across all cells}

\item{\code{positionMatrices}}{a list of position matrices}

\item{\code{finalPositionMatrix}}{a matrix representing the final position matrix}

\item{\code{readCounts}}{a numeric vector for read counts per nucleotide}
}}

\note{
The \code{simulatePolymerase} function can take a few minutes to run for
large numbers of cells (> 1000) and long simulation times (> 200).
}
\examples{
# Create a SimulatePolymerase object
sim <- simulatePolymerase(
    k = 50, ksd = 25, kMin = 17, kMax = 200, geneLen = 1950,
    alpha = 1, beta = 1, zeta = 2000, zetaSd = 1000, zetaMin = 1500,
    zetaMax = 2500, zetaVec = NULL, cellNum = 100, polSize = 33, 
    addSpace = 17, time = 1, timesToRecord = NULL
)
# Create a SimulatePolymerase object with specific time points recorded
sim2 <- simulatePolymerase(
    k = 50, ksd = 25, kMin = 17, kMax = 200, geneLen = 1950,
    alpha = 1, beta = 1, zeta = 2000, zetaSd = 1000, zetaMin = 1500, zetaMax
= 2500,
    zetaVec = NULL, cellNum = 1000, polSize = 33, addSpace = 17, time = 1,
    timesToRecord = c(0.5, 1.0)
)
# Create a SimulatePolymerase object
sim <- simulatePolymerase(
    k = 50, ksd = 25, kMin = 17, kMax = 200, geneLen = 1950,
    alpha = 1, beta = 1, zeta = 2000, zetaSd = 1000, zetaMin = 1500, 
    zetaMax = 2500, zetaVec = NULL, cellNum = 100, polSize = 33, 
    addSpace = 17, time = 1, timesToRecord = NULL
)
# Sample read counts per nucleotide
sim <- sampleReadCounts(sim)
# Print the read counts per nucleotide
print(readCounts(sim))
# Create a SimulatePolymerase object
sim <- simulatePolymerase(
    k = 50, ksd = 25, kMin = 17, kMax = 200, geneLen = 1950,
    alpha = 1, beta = 1, zeta = 2000, zetaSd = 1000, zetaMin = 1500, 
    zetaMax = 2500, zetaVec = NULL, cellNum = 100, polSize = 33, 
    addSpace = 17, time = 1, timesToRecord = c(0.5, 1.0))
# Plot final position matrix
plotPositionHeatmap(sim, file="position_heatmap.png")
# Plot position matrix at time 0.5
plotPositionHeatmap(sim, timePoint = 0.5, file="position_heatmap.png")
# Plot position matrix with maxCells = 100
plotPositionHeatmap(sim, timePoint = 0.5, maxCells = 100,
file="position_heatmap.png")
# Create a SimulatePolymerase object
sim <- simulatePolymerase(
    k = 50, ksd = 25, kMin = 17, kMax = 200, geneLen = 1950,
    alpha = 1, beta = 1, zeta = 2000, zetaSd = 1000, zetaMin = 1500, 
    zetaMax = 2500, zetaVec = NULL, cellNum = 100, polSize = 33,
    addSpace = 17, time = 1, timesToRecord = c(0.5, 1.0))
# Plot final combined cells data
plotCombinedCells(sim, file="combined_cells.png")
# Plot specific time point data
plotCombinedCells(sim, timePoint = 0.5, file="combined_cells.png")
# Plot with custom range and title
plotCombinedCells(sim, timePoint = 0.5, start = 100, end = 500,
file="combined_cells.png")
}
