% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-accessor.R, R/methods-show.R
\name{SVP-accessors}
\alias{SVP-accessors}
\alias{spatialCoords,SVPExperiment-method}
\alias{spatialCoordsNames,SVPExperiment-method}
\alias{imgData,SVPExperiment-method}
\alias{show,SVPExperiment-method}
\alias{spatialCoordsNames<-,SVPExperiment,character-method}
\alias{imgData<-,SVPExperiment,DataFrame-method}
\alias{imgData<-,SVPExperiment,NULL-method}
\alias{spatialCoords<-,SVPExperiment,matrix_Or_NULL-method}
\alias{spatialCoords<-,SVPExperiment}
\title{Some accessor functions to get the internal slots of SVPExperiment}
\usage{
\S4method{spatialCoords}{SVPExperiment}(x)

\S4method{spatialCoordsNames}{SVPExperiment}(x)

\S4method{imgData}{SVPExperiment}(x)

\S4method{imgData}{SVPExperiment,DataFrame}(x) <- value

\S4method{imgData}{SVPExperiment,NULL}(x) <- value

\S4method{spatialCoords}{SVPExperiment,matrix_Or_NULL}(x) <- value

\S4method{spatialCoordsNames}{SVPExperiment,character}(x) <- value

\S4method{show}{SVPExperiment}(object)
}
\arguments{
\item{x}{a \linkS4class{SVPExperiment} class.}

\item{value}{matrix for \code{spatialCoords(object) <- value}
character for \code{spatialCoordsNames(object) <- value}.}

\item{object}{a \linkS4class{SVPExperiment} class.}
}
\value{
matrix or character or print the information of object
or a \linkS4class{SVPExperiment} object.
}
\description{
Some accessor functions to get the internal slots of SVPExperiment
}
\examples{
library(SpatialExperiment) |> suppressPackageStartupMessages()
library(DropletUtils) |> suppressPackageStartupMessages()
example(read10xVisium, echo = FALSE)
svpe <- as(spe, 'SVPExperiment')
svpe
spatialCoords(svpe) |> head()
}
