% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-lisa.R
\name{extract_weight_adj}
\alias{extract_weight_adj}
\alias{extract_weight_adj,SingleCellExperiment-method}
\alias{extract_weight_adj,SingleCellExperiment}
\title{extract the cell adjacent matrix from spatial space or reduction space}
\usage{
extract_weight_adj(
  data,
  sample_id = "all",
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  cells = NULL,
  ...
)

\S4method{extract_weight_adj}{SingleCellExperiment}(
  data,
  sample_id = "all",
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  cells = NULL,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object.}

\item{sample_id}{character the sample(s) in the \linkS4class{SpatialExperiment} object whose cells/spots to use.
Can be \code{all} to compute metric for all samples; the matrix is computed separately for each sample.
default is \code{"all"}.}

\item{weight.method}{character the method to build the spatial neighbours weights, default
is \code{voronoi} (Voronoi tessellation). Other method, which requires coord matrix as input and returns
\code{nb}, \code{listw} or \code{Graph} object, also is available, such as \code{"knearneigh"},
\code{'dnearneigh'}, \code{"gabrielneigh"}, \code{"relativeneigh"}, which are from \code{spdep} package.
default is \code{knn}, if it is \code{"none"}, meaning the distance weight of each spot is used to
the weight.}

\item{reduction.used}{character used as spatial coordinates to calculate the neighbours weights,
default is \code{NULL}, the result of reduction can be specified, such as \code{UMAP}, \code{TSNE}, \code{PCA}.
If it is specified, the weight neighbours matrix will be calculated using the result of specified reduction.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}, if it was specified, the adjacency weighted matrix will be built based on the principle
that spots or cells in the same category are adjacent, default is NULL.}

\item{cells}{the cell name or index of data object, default is NULL.}

\item{...}{additional parameters, when \code{weight.method='knn'}, you can specified \code{k=10}.}
}
\value{
a dgCMatrix object
}
\description{
the function provides \code{voronoi} or \code{knn} method to build the
cell adjacent matrix.
}
\examples{
data(hpda_spe_cell_dec)
# knn method
wm <- extract_weight_adj(hpda_spe_cell_dec, weight.method='knn', k=7)
# voronoi method
wm <- extract_weight_adj(hpda_spe_cell_dec)
# specified group.by
wm <- extract_weight_adj(hpda_spe_cell_dec, group.by='cluster_domain')
}
