% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-wkde.R
\name{runWKDE}
\alias{runWKDE}
\alias{runWKDE,SingleCellExperiment-method}
\alias{runWKDE,SingleCellExperiment}
\alias{runWKDE,SVPExperiment-method}
\alias{runWKDE,SVPExperiment}
\title{Calculating the 2D Weighted Kernel Density Estimation}
\usage{
runWKDE(
  data,
  assay.type = "logcounts",
  reduction.used = NULL,
  grid.n = 100,
  adjust = 1,
  bandwidths = NULL,
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{runWKDE}{SingleCellExperiment}(
  data,
  assay.type = "logcounts",
  reduction.used = NULL,
  grid.n = 100,
  adjust = 1,
  bandwidths = NULL,
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{runWKDE}{SVPExperiment}(
  data,
  assay.type = "logcounts",
  reduction.used = NULL,
  grid.n = 100,
  adjust = 1,
  bandwidths = NULL,
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{reduction.used}{character used as spatial coordinates to detect SVG, default is NULL,
if \code{data} has \code{spatialCoords}, which will be used as spatial coordinates, if this is provided
the coordinate of specified reduced result will be used.}

\item{grid.n}{integer number of grid points in the two directions to estimate 2D weighted kernel density, default is 100.}

\item{adjust}{numeric to adjust the \code{bandwidths}, default is 1.0.}

\item{bandwidths}{vector a two length numeric vector represents the bandwidths for x and y directions, default is normal
reference bandwidth \code{\link[ks]{hpi}}, see also \code{\link[MASS]{bandwidth.nrd}}.}

\item{verbose}{logical whether print the intermediate message when running the program, default is TRUE.}

\item{gsvaexp}{which gene set variation experiment will be pulled to run, this only work when \code{data} is a
\linkS4class{SVPExperiment}, default is NULL.}

\item{gsvaexp.assay.type}{which assay data in the specified \code{gsvaexp} will be used to run, default is NULL.}

\item{...}{additional parameters}
}
\value{
a \linkS4class{SVPExperiment} or \linkS4class{SingleCellExperiment}
}
\description{
Calculating the 2D Weighted Kernel Density Estimation
}
\examples{
library(SpatialExperiment)
data(hpda_spe_cell_dec)
hpda_spe_cell_dec <- hpda_spe_cell_dec |> runWKDE(assay.type = 'affi.score')
# The result is saved in the assays (affi.score.density name) of SVPExperiment
# which can be extracted using assay and visualized using ggsc or
# other packages
assays(hpda_spe_cell_dec)
#\donttest{
    library(ggsc)
    
    f1 <- sc_spatial(hpda_spe_cell_dec, features="Cancer clone A",
               mapping=aes(x=x,y=y),
               slot = 'affi.score.density',
               pointsize=10
    ) +
    scale_bg_color_manual(values=c('black'))
    f1
    
    f2 <- sc_spatial(hpda_spe_cell_dec, features="Cancer clone B",
               mapping=aes(x=x,y=y),
               pointsize=10,
               slot = 'affi.score.density'
    ) +
    scale_bg_color_manual(values=c('black'))
    f2
#}
}
\author{
Shuangbin Xu
}
