% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developerAPIS.R
\name{listSharedObjects}
\alias{listSharedObjects}
\title{List all shared Objects}
\usage{
listSharedObjects(end = NULL, start = NULL)
}
\arguments{
\item{end}{the end value of the ID. The default is \code{NULL}. See details.}

\item{start}{the start value of the ID. The default is \code{NULL}. See details.}
}
\value{
A data.frame object with shared object id and size
}
\description{
List all shared Objects
}
\details{
The parameter \code{start} and \code{end} specify the range of the ID. If not specified, all
IDs will be listed.

On Ubuntu or some other linux systems, the shared objects
can be found in the folder \verb{/dev/shm}. The function can find all shared objects
if the folder exists.

On Windows, since there is no easy way to find all shared objects.
the function will guess the range of the shared object IDs and search
for all IDs within the range. Therefore, if there are too many shared
objects(over 4 billions) ,the object id can be out of the searching range
and the result may not be complete.
Furthermore, there will be no named shared memory in the returned list.

Note that the size in the return value is the true memory size
that is reserved for the shared object, so it might be larger
than the object size.
}
\examples{
x <- share(runif(10))
## Automatically determine the search range
listSharedObjects()

## specify the search range
listSharedObjects(start = 10, end = 20)

## Search from 0 to 20
listSharedObjects(20)
}
\seealso{
\code{\link{getLastIndex}}, \code{\link{allocateSharedMemory}},
\code{\link{mapSharedMemory}}, \code{\link{unmapSharedMemory}},
\code{\link{freeSharedMemory}}, \code{\link{hasSharedMemory}}, \code{\link{getSharedMemorySize}}
}
