% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellAlleleExperiment.R
\name{alleles2genes}
\alias{alleles2genes}
\title{Building first new subassay for SingleCellAllelexperiment object}
\usage{
alleles2genes(sce, lookup, exp_type, gene_symbols)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{lookup}{A data.frame object containing the lookup table.}

\item{exp_type}{Internal character string parameter that determines in which
format the gene symbols in the input data are. Can be \code{c("ENS","noENS")}}

\item{gene_symbols}{A logical parameter to decide whether to compute additional
gene gene symbols in case the raw data only contains ENSEMBL gene identifiers.}
}
\value{
A SingleCellExperiment object
}
\description{
Internal function for the first assay extension used in the
\code{SingleCellAlleleExperiment()} constructor, computing the first of the two
new subassays that get appended to the quantification assay.
This subassay contains the allele gene identifiers instead of the
allele identifiers present in the raw data and sums up the expression counts
of alleles that have the same allele gene identifiers.
}
