% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling.r
\name{FilterByConversionRate}
\alias{FilterByConversionRate}
\title{Calculate reads conversion rate}
\usage{
FilterByConversionRate(MethSM, chr, genome, thr)
}
\arguments{
\item{MethSM}{as comes out of the func GetSingleMolMethMat}

\item{chr}{Chromosome, MethSM doesn't carry this info}

\item{genome}{BSgenome}

\item{thr}{Double between 0 and 1. Threshold below which to filter reads.}
}
\value{
Filtered MethSM
}
\description{
Calculate reads conversion rate
}
\examples{

library(BSgenome.Mmusculus.UCSC.mm10)
MethSM = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))[[2]]$SMF_MM_TKO_DE_
FilterByConversionRate(MethSM, chr = "chr19", 
genome = BSgenome.Mmusculus.UCSC.mm10, thr = 0.8)

}
