% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{SortReadsByTFCluster}
\alias{SortReadsByTFCluster}
\title{Wrapper to SortReads for TF cluster case}
\usage{
SortReadsByTFCluster(
  MethSM,
  TFBS_cluster,
  bins = list(c(-35, -25), c(-7, 7), c(25, 35)),
  coverage = 30
)
}
\arguments{
\item{MethSM}{Single molecule matrix list as returned by CallContextMethylation}

\item{TFBS_cluster}{Transcription factor binding sites to use for sorting, passed as a GRanges object of length > 1}

\item{bins}{list of 3 relative bin coordinates. Defaults to list(c(-35,-25), c(-7,7), c(25,35)).
bins[[1]] represents the upstream bin, with coordinates relative to the start of the most upstream TFBS.
bins[[2]] represents all the TFBS bins, with coordinates relative to the center of each TFBS.
bins[[3]] represents the downstream bin, with coordinates relative to the end of the most downstream TFBS.}

\item{coverage}{integer. Minimum number of reads covering all sorting bins for sorting to be performed. Defaults to 30}
}
\value{
List of reads sorted by TF cluster
}
\description{
Wrapper to SortReads for TF cluster case
}
\examples{

Methylation = qs::qread(system.file("extdata", "Methylation_4.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_1.qs", 
package="SingleMoleculeFootprinting"))

SortedReads = SortReadsByTFCluster(MethSM = Methylation[[2]], TFBS_cluster = TFBSs)

}
