% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{StateQuantificationBySingleTF}
\alias{StateQuantificationBySingleTF}
\title{Convenience for calculating state frequencies after sorting reads by single TF}
\usage{
StateQuantificationBySingleTF(SortedReads)
}
\arguments{
\item{SortedReads}{List of sorted reads (can be multiple samples) as returned by SortReadsBySingleTF (or SortReads run with analogous parameters)}
}
\value{
tibble with state frequency information
}
\description{
wraps around StateQuantification function
}
\examples{

Methylation = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_3.qs", 
package="SingleMoleculeFootprinting"))
SortedReads = SortReadsBySingleTF(MethSM = Methylation[[2]], TFBS = TFBSs)
StateQuantificationBySingleTF(SortedReads = SortedReads)

}
