% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDeltaDistribution.R
\name{plotDeltaDistribution}
\alias{plotDeltaDistribution}
\title{Plot delta distributions}
\usage{
plotDeltaDistribution(
  results,
  show = c("delta.med", "delta.next"),
  labels.use = NULL,
  references = NULL,
  chosen.only = TRUE,
  size = 2,
  ncol = 5,
  dots.on.top = TRUE,
  this.color = "#000000",
  pruned.color = "#E69F00",
  grid.vars = list()
)
}
\arguments{
\item{results}{A \link[S4Vectors]{DataFrame} containing the output from \code{\link{SingleR}}, \code{\link{classifySingleR}}, or \code{\link{combineRecomputedResults}}.}

\item{show}{String specifying whether to show the difference from the median (\code{"delta.med"}) 
or the difference from the next-best score (\code{"delta.next"}).}

\item{labels.use}{Character vector specifying the labels to show in the plot facets.
Defaults to all labels in \code{results}.}

\item{references}{Integer scalar or vector specifying the references to visualize.
This is only relevant for combined results, see Details.}

\item{chosen.only}{Logical scalar indicating whether to only show deltas 
for individual labels that were chosen as the final label in a combined result.}

\item{size}{Numeric scalar to set the size of the dots.}

\item{ncol}{Integer scalar to set the number of labels to display per row.}

\item{dots.on.top}{Logical scalar specifying whether cell dots should be plotted on top of the violin plots.}

\item{this.color}{String specifying the color for cells that were assigned to the label.}

\item{pruned.color}{String specifying the color for cells that were assigned to the label but pruned.}

\item{grid.vars}{Named list of extra variables to pass to \code{\link[gridExtra]{grid.arrange}},
used to arrange the multiple plots generated when \code{references} is of length greater than 1.}
}
\value{
If \code{references} specifies a single set of deltas,
a \link[ggplot2]{ggplot} object is returned showing the deltas in violin plots.

If \code{references} specifies multiple deltas for a combined result,
multiple ggplot objects are generated in a grid on the current graphics device.

If \code{delta.use} specifies multiple deltas and \code{grid.vars} is set to \code{NULL},
a list is returned containing the ggplot objects for manual display.
}
\description{
Plot the distribution of deltas 
(i.e., the gap between the assignment score for the assigned label and those of the remaining labels)
across cells assigned to each reference label.
}
\details{
This function creates jitter and violin plots showing the deltas for all cells across one or more labels.
The idea is to provide a visual diagnostic for the confidence of assignment of each cell to its label.
The \code{show} argument determines what values to show on the y-axis:
\itemize{
\item \code{"delta.med"}, the difference between the score of the assigned label and the median of all scores for each cell.
\item \code{"delta.next"}, the difference between best and second-best scores of each cell at the last round of fine-tuning.
}

If any fine-tuning was performed, the highest scoring label for an individual cell may not be its final label.
This may manifest as negative values when \code{show="delta.med"}.
\code{show="delta.next"} is guaranteed to be positive but may be overly stringent for references involving very similar labels.

Pruned calls are identified as \code{NA}s in the \code{pruned.labels} field in \code{results}.
Points corresponding to cells with pruned calls are colored by \code{pruned.color};
this can be disabled by setting \code{pruned.color=NA}.

For combined results (see \code{?\link{combineRecomputedResults}}),
this function will show the deltas faceted by the assigned label within each individual reference.
The references to show in this manner can be specified using the \code{references} argument, 
entries of which refer to columns of \code{results$orig.results}.

By default, a separate plot is created for each individual reference in a combined \code{results}.
Deltas are only shown in each plot if the label in the corresponding reference 
was chosen as the overall best label in the combined results.
However, this can be changed to show all deltas for an individual reference by setting \code{chosen.only=FALSE}.
}
\examples{
example(SingleR, echo=FALSE)

# Showing the delta to the median:
plotDeltaDistribution(pred)

# Showing the delta to the next-highest score:
plotDeltaDistribution(pred, show = "delta.next")

# Multi-reference compatibility:
example(combineRecomputedResults, echo = FALSE)

plotDeltaDistribution(results = combined)

plotDeltaDistribution(results = combined, chosen.only=FALSE)

# Tweaking the grid controls:
plotDeltaDistribution(combined, grid.vars = list(ncol = 2))

}
\seealso{
\code{\link{pruneScores}}, to remove low-quality labels based on the scores.

\code{\link{plotScoreDistribution}} and \code{\link{plotScoreHeatmap}}, for alternative diagnostic plots.
}
\author{
Daniel Bunis and Aaron Lun
}
