% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakwiseAssociations.R
\name{getTargetGenesPvalsWithIntensities}
\alias{getTargetGenesPvalsWithIntensities}
\title{Fit log-normal distribution to target genes}
\usage{
getTargetGenesPvalsWithIntensities(
  associationBy = "distance",
  intensities,
  geneCoordinates = NA,
  sites = NA,
  distance = 50000,
  givenRegions = NA
)
}
\arguments{
\item{associationBy}{either "distance" or "regions"}

\item{intensities}{intensity values associated to sites}

\item{geneCoordinates}{granges coordinates of genes}

\item{sites}{granges coordinates of sites}

\item{distance}{the maximum distance to associate sites to genes. default 50K}

\item{givenRegions}{user provided granges regions like TADs or loops}
}
\value{
A vector of pvalue distribution for target genes
}
\description{
Get genes and sites coordinates, and associate them by given

distance or given regions (ex. TADs or loops). It tests the

distribution of log-intensities of sites around genes by

log-normal test. This function consider both binding sites and

intensities.
}
\examples{

geneFile=system.file("extdata", "gene_expression.tsv", package="Site2Target")
geneCoords <- Table2Granges(geneFile)

tfFile =system.file("extdata", "MEIS_binding.tsv", package="Site2Target")
TFCoords <- Table2Granges(tfFile)
tfTable <- read.table(tfFile, header=TRUE)
tfIntensities <- tfTable$intensities

pvals <- getTargetGenesPvalsWithIntensities(geneCoordinates=geneCoords,
                      sites=TFCoords, intensities=tfIntensities)

}
