% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_gene_set_specificity}
\alias{calculate_gene_set_specificity}
\title{calculate_gene_set_specificity}
\usage{
calculate_gene_set_specificity(
  data,
  spPatterns,
  gene_sets,
  weighted = TRUE,
  method = c("geometric_mean", "arithmetic_mean")
)
}
\arguments{
\item{data}{A numeric matrix or data frame of gene expression values (genes x samples).}

\item{spPatterns}{A data frame or matrix containing spatial pattern information, with columns for cell types and optionally "x", "y", "barcode".}

\item{gene_sets}{A named list of character vectors, where each vector contains gene names for a gene set.}

\item{weighted}{Logical; if TRUE, gene scores are weighted by their occurrence in multiple gene sets.}

\item{method}{Character; specifies the aggregation method for gene set scores. Options are "geometric_mean" or "arithmetic_mean".}
}
\value{
A numeric matrix of gene set specificity scores (gene sets x cell types).
}
\description{
This function computes specificity scores for given gene sets across cell types or spatial patterns.
It uses fold-change scores and p-values to weight gene contributions, and supports both geometric and arithmetic means.
}
\details{
Calculate Gene Set Specificity Scores
\itemize{
\item Genes not present in the data are excluded.
\item Genes with all zero expression are removed.
\item Fold-change scores and p-values are calculated using \code{.calculate_all_fc_scores}.
\item Scores are normalized and weighted by p-value significance.
\item For each gene set, scores are aggregated using the specified method and gene weights.
}
}
\examples{
# Example usage:
# gene_set_scores <- calculate_gene_set_specificity(expr_matrix, spPatterns, gene_sets)

}
