% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInteractingGenes.R
\name{get_pairwise_interacting_genes}
\alias{get_pairwise_interacting_genes}
\title{get_pairwise_interacting_genes}
\usage{
get_pairwise_interacting_genes(
  data,
  spPatterns,
  mode = c("DE", "residual"),
  optParams = NULL,
  reconstruction = NULL,
  hotspots = NULL,
  minOverlap = 50,
  analysis = c("enrichment", "overlap"),
  pattern_pairs = NULL,
  ...,
  workers = NULL
)
}
\arguments{
\item{data}{original spatial data matrix.}

\item{spPatterns}{A data frame that contains the spatial coordinates
and metrics for spatial features (cell types/cell processes). The column
names must include 'x' and 'y' as well as the spatially varying features.}

\item{mode}{SpaceMarkers mode of operation. Possible values are
"DE" (the default) or "residual".}

\item{optParams}{a matrix with dimensions 2 X N, where N is the number
of spatial patterns with optimal parameters. The first row contains the
kernel width 'sigmaOpt' for each pattern, and the second row is the
threshOpt (outlier threshold) for each pattern. Users can also input their
preferred param values. The default value is NULL.}

\item{reconstruction}{reconstruction of the data matrix from latent
spaces. Required for "residual" mode.}

\item{hotspots}{a vector that specifies the patterns to compare
to the 'refPattern'. The default is NULL which indicates that all patterns
would be compared to the 'refPattern'.}

\item{minOverlap}{a number that specifies the minimum overlap between
genes in two patterns to be considered for the statistical tests.
The default is 50.}

\item{analysis}{a character string that specifies the type of downstream
analysis to be performed. Possible values are "enrichment" (default)
and "overlap". In enrichment mode, all genes are returned, ranked by
the SpaceMarkers metric. In overlap mode, only the genes which are
significantly overexpressed in the interaction region are returned.}

\item{pattern_pairs}{A matrix of pattern pairs to be analyzed. Default is}

\item{...}{Arguments passed to methods}

\item{workers}{(optional) Number of workers to
be used for parallel processing.}
}
\value{
a list of data frames for each pattern with 1) names of the patterns
(patterns object) 2) data frame with the hotspots of influence for the
two patterns (the hotspots object). 3) data frame with the genes
associated with the interaction between the two patterns
(interacting genes object, empty if insufficient interaction).
}
\description{
Performs pairwise analysis to find genes associated with
spatial interaction between pairs of spatially varying patterns.
}
\details{
================
}
\examples{
library(SpaceMarkers)
#Visium data links
urls <- read.csv(system.file("extdata","visium_data.txt",
package="SpaceMarkers",mustWork = TRUE))
counts_url <- urls[["visium_url"]][1]
sp_url <- urls[["visium_url"]][2]
#Remove present Directories if any
unlink(basename(sp_url))
unlink("spatial", recursive = TRUE)
files <- list.files(".")[grepl(basename(counts_url),list.files("."))]
unlink(files)
download.file(counts_url,basename(counts_url), mode = "wb")
counts_matrix<-load10XExpr(visiumDir=".",
h5filename = basename(counts_url))
#Obtaining CoGAPS Patterns
cogaps_result <- readRDS(system.file("extdata","CoGAPS_result.rds",
package="SpaceMarkers",mustWork = TRUE))
features <- intersect(rownames(counts_matrix),rownames(
    slot(cogaps_result,"featureLoadings")))
barcodes <- intersect(colnames(counts_matrix),rownames(
    slot(cogaps_result,"sampleFactors")))
counts_matrix <- counts_matrix[features,barcodes]
cogaps_matrix <- slot(cogaps_result,"featureLoadings")[features,]\%*\%
    t(slot(cogaps_result,"sampleFactors")[barcodes,])
#Obtaining Spatial Coordinates
download.file(sp_url, basename(sp_url), mode = "wb")
untar(basename(sp_url))
spCoords <- load10XCoords(visiumDir = ".", version = "1.0")
rownames(spCoords) <- spCoords$barcode
spCoords <- spCoords[barcodes,]
spPatterns <- cbind(spCoords,
slot(cogaps_result,"sampleFactors")[barcodes,])
data("curated_genes")
spPatterns<-spPatterns[c("barcode","y","x","Pattern_1",
"Pattern_3","Pattern_5")]
counts_matrix <- counts_matrix[curated_genes,]
cogaps_matrix <- cogaps_matrix[curated_genes, ]
optParams <- matrix(c(6, 2, 6, 2, 6, 2), nrow = 2)
rownames(optParams) <- c("sigmaOpt","threshOpt")
colnames(optParams) <- c("Pattern_1","Pattern_3","Pattern_5")
SpaceMarkersMode <- "DE"
pattern_pairs <- matrix(c("Pattern_1", "Pattern_1", 
           "Pattern_3", "Pattern_5"), nrow=2)
SpaceMarkers <- get_pairwise_interacting_genes(
    data=counts_matrix,reconstruction=NULL,
    optParams = optParams,
    spPatterns = spPatterns,
    mode="DE",analysis="enrichment", pattern_pairs=pattern_pairs)
#Remove present Directories if any
unlink(basename(sp_url))
unlink("spatial", recursive = TRUE)
files <- list.files(".")[grepl(basename(counts_url),list.files("."))]
unlink(files)

}
\seealso{
Other getIntGenes: 
\code{\link{find_pattern_hotspots}()},
\code{\link{get_interacting_genes}()}
}
\concept{getIntGenes}
