% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotZoomFovsMap}
\alias{plotZoomFovsMap}
\title{plotZoomFovsMap}
\usage{
plotZoomFovsMap(
  spe,
  fovs = NULL,
  title = NULL,
  mapPointCol = "darkmagenta",
  mapNumbersCol = "black",
  mapAlphaNumbers = 0.8,
  csize = 0.05,
  calpha = 0.8,
  scaleBars = NULL,
  scaleBarMap = TRUE,
  scaleBarPol = TRUE,
  ...
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial transcriptomics
data.}

\item{fovs}{A character vector specifying the FOVs to be zoomed in and
plotted. Must match values in the `fov` column of `colData(spe)`.}

\item{title}{An optional character string specifying the title of the final
plot. If `NULL`, no title is added. Default is `NULL`.}

\item{mapPointCol}{A character string specifying the color of the points
in the map. Default is `"darkmagenta"`.}

\item{mapNumbersCol}{A character string specifying the color of the
numbers on the map. Default is `"black"`.}

\item{mapAlphaNumbers}{A numeric value specifying the transparency of the
numbers on the map. Default is `0.8`.}

\item{csize}{A numeric value specifying the size of the points in the map.
Default is `0.05`.}

\item{calpha}{A numeric value specifying the transparency of the points in
the map. Default is `0.8`.}

\item{scaleBars}{Logical or NULL. Default is `NULL`.
Master switch controlling the presence of scale bars in both panels.
If \code{TRUE}, scale bars are shown in both the map and polygon panels.
If \code{FALSE}, scale bars are hidden in both panels.
If \code{NULL}, individual settings defined by \code{scaleBarMap} and
\code{scaleBarPol} are used.}

\item{scaleBarMap, scaleBarPol}{Logical. Default is \code{TRUE}.
Control the presence of the scale bar in the map (cells/FOV overview)
and polygon (segmentation) panels, respectively.
These parameters are only used when \code{scaleBars} is \code{NULL};
otherwise they are overridden by \code{scaleBars}.}

\item{...}{Additional arguments passed to `plotPolygons`.}
}
\value{
A combined plot showing a map of all FOVs with zoomed-in views of
the specified FOVs and their associated polygons.
}
\description{
Plot Zoomed-in FOVs with Map and Polygons

This function generates a plot that shows a map of all fields of view (FOVs)
within a `SpatialExperiment` object, alongside a zoomed-in view of the
specified FOVs with an overlay of polygons and optional coloring.
}
\details{
The function first filters the `SpatialExperiment` object to the
specified FOVs, generates a plot of the cells for the entire map, then
creates a detailed polygon plot of the selected FOVs, and finally combines
these into a single side-by-side visualization. If `title` is not `NULL`, it
adds a title to the combined plot.
}
\examples{
example(readAndAddPolygonsToSPE)
plotZoomFovsMap(spe, fovs=16, title="FOV 16")
}
