% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFE-class.R
\name{SpatialFeatureExperiment}
\alias{SpatialFeatureExperiment}
\title{Constructor of SpatialFeatureExperiment object}
\usage{
SpatialFeatureExperiment(
  assays,
  colData = DataFrame(),
  rowData = NULL,
  sample_id = "sample01",
  spatialCoordsNames = c("x", "y"),
  spatialCoords = NULL,
  colGeometries = NULL,
  rowGeometries = NULL,
  annotGeometries = NULL,
  spotDiameter = NA_real_,
  annotGeometryType = "POLYGON",
  spatialGraphs = NULL,
  unit = c("full_res_image_pixel", "micron"),
  ...
)
}
\arguments{
\item{assays}{
    A \code{list} or \code{SimpleList} of matrix-like elements,
    or a matrix-like object (e.g. an ordinary matrix, a data frame,
    a \link[S4Vectors]{DataFrame} object from the \pkg{S4Vectors} package,
    a \link[SparseArray]{SparseMatrix} derivative from the \pkg{SparseArray}
    package, a \link[Matrix]{sparseMatrix} derivative from the \pkg{Matrix}
    package, a \link[DelayedArray]{DelayedMatrix} object from the
    \pkg{DelayedArray} package, etc...).
    All elements of the list must have the same dimensions, and dimension
    names (if present) must be consistent across elements and with the row
    names of \code{rowRanges} and \code{colData}.
  }

\item{colData}{
    An optional \link{DataFrame} describing the samples. Row names on
    \code{colData}, if present, become the column names of the returned object.
  }

\item{rowData}{
    \code{NULL} (the default) or a \link[S4Vectors]{DataFrame} object
    describing the rows. Row names, if present, become the row names of
    the constructed SummarizedExperiment object. The number of rows of
    the \link[S4Vectors]{DataFrame} must equal the number of rows of the
    matrices in \code{assays}.
  }

\item{sample_id}{A \code{character} sample identifier, which matches the
\code{sample_id} in \code{\link[SpatialExperiment]{imgData}}. The \code{sample_id} will also
be stored in a new column in \code{\link[SpatialExperiment]{colData}}, if not already present.
Default = \code{sample01}.}

\item{spatialCoordsNames}{A \code{character} vector of column names if
\code{*Geometries} arguments have ordinary data frames, to identify the
columns in the ordinary data frames that specify the spatial coordinates.
If \code{colGeometries} is not specified, then this argument will behave as
in \code{\link[SpatialExperiment]{SpatialExperiment}}, but \code{colGeometries} will be given
precedence if provided.}

\item{spatialCoords}{A numeric matrix containing columns of spatial
coordinates, as in \code{\link[SpatialExperiment]{SpatialExperiment}}. The coordinates are
centroids of the entities represented by the columns of the gene count
matrix. If \code{colGeometries} is also specified, then it will be given
priority and a warning is issued. Otherwise, the \code{sf} representation
of the centroids will be stored in the \code{colGeometry} called
\code{centroids}.}

\item{colGeometries}{Geometry of the entities that correspond to the columns
of the gene count matrix, such as cells and Visium spots. It must be a
named list of one of the following: \describe{ \item{An \code{sf} data
frame}{The geometry column specifies the geometry of the entities.}
\item{An ordinary data frame specifying centroids}{Column names for the
coordinates are specified in the \code{spatialCoordsNames} argument. For
Visium and ST, in addition to the centroid coordinate data frame, the spot
diameter in the same unit as the coordinates can be specified in the
\code{spotDiamter} argument.} \item{An ordinary data frame specifying
polygons}{Also use \code{spatialCoordsNames}. There should an additional
column "ID" to specify which vertices belong to which polygon. The
coordinates should not be in list columns. Rather, the data frame should
look like it is passed to \code{ggplot2::geom_polygon}. If there are holes,
then there must also be a column "subID" that differentiates between the
outer polygon and the holes.}} In all cases, the data frame should specify
the same number of geometries as the number of columns in the gene count
matrix. If the column "barcode" is present, then it will be matched to
column names of the gene count matrix. Otherwise, the geometries are
assumed to be in the same order as columns in the gene count matrix. If the
geometries are specified in an ordinary data frame, then it will be
converted into \code{sf} internally. Named list of data frames because each
entity can have multiple geometries, such as whole cell and nuclei
segmentations. The geometries are assumed to be POINTs for centroids and
POLYGONs for segmentations. If polygons are specified in an ordinary data
frame, then anything with fewer than 3 vertices will be removed. For
anything other than POINTs, attributes of the geometry will be ignored.}

\item{rowGeometries}{Geometry associated with genes or features, which
correspond to rows of the gene count matrix.}

\item{annotGeometries}{Geometry of entities that do not correspond to columns
or rows of the gene count matrix, such as tissue boundary and pathologist
annotations of histological regions, and nuclei segmentation in a Visium
dataset. Also a named list as in \code{colGeometries}. The ordinary data
frame may specify POINTs, POLYGONs, or LINESTRINGs, or their MULTI
versions. Each data frame can only specify one type of geometry. For MULTI
versions, there must be a column "group" to identify each MULTI geometry.}

\item{spotDiameter}{Spot diameter for technologies with arrays of spots of
fixed diameter per slide, such as Visium, ST, DBiT-seq, and slide-seq. The
diameter must be in the same unit as the coordinates in the *Geometry
arguments. Ignored for geometries that are not POINT or MULTIPOINT.}

\item{annotGeometryType}{Character vector specifying geometry type of each
element of the list if \code{annotGeometry} is specified. Each element of
the vector must be one of POINT, LINESTRING, POLYGON, MULTIPOINT,
MULTILINESTRING, and MULTIPOLYGON. Must be either length 1 (same for all
elements of the list) or the same length as the list. Ignored if the
corresponding element is an \code{sf} object.}

\item{spatialGraphs}{A named list of \code{listw} objects (see \code{spdep})
for spatial neighborhood graphs.}

\item{unit}{Unit the coordinates are in, either microns or pixels in full
resolution image.}

\item{...}{Additional arguments passed to the \code{\link[SpatialExperiment]{SpatialExperiment}}
and \code{\link[SingleCellExperiment]{SingleCellExperiment}} constructors.}
}
\value{
A SFE object. If neither \code{colGeometries} nor \code{spotDiameter}
  is specified, then a \code{colGeometry} called "centroids" will be made,
  which is essentially the spatial coordinates as sf POINTs. If
  \code{spotDiameter} is specified, but not \code{colGeometries}, then the
  spatial coordinates will be buffered by half the diameter to get spots with
  the desired diameter, and the resulting \code{colGeometry} will be called
  "spotPoly", for which there's a convenience getter and setter,
  \code{\link{spotPoly}}.
}
\description{
Create a \code{SpatialFeatureExperiment} object.
}
\examples{
library(Matrix)
data("visium_row_col")
coords1 <- visium_row_col[visium_row_col$col < 6 & visium_row_col$row < 6, ]
coords1$row <- coords1$row * sqrt(3)
cg <- df2sf(coords1[, c("col", "row")], c("col", "row"), spotDiameter = 0.7)

set.seed(29)
col_inds <- sample(seq_len(13), 13)
row_inds <- sample(seq_len(5), 13, replace = TRUE)
values <- sample(seq_len(5), 13, replace = TRUE)
mat <- sparseMatrix(i = row_inds, j = col_inds, x = values)
colnames(mat) <- coords1$barcode
rownames(mat) <- sample(LETTERS, 5)
rownames(cg) <- colnames(mat)

sfe <- SpatialFeatureExperiment(list(counts = mat),
    colData = coords1,
    spatialCoordsNames = c("col", "row"),
    spotDiameter = 0.7
)
sfe2 <- SpatialFeatureExperiment(list(counts = mat),
    colGeometries = list(foo = cg)
)
}
\concept{SpatialFeatureExperiment class}
