% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureData.R
\name{colFeatureData}
\alias{colFeatureData}
\alias{rowFeatureData}
\alias{geometryFeatureData}
\alias{reducedDimFeatureData}
\title{Get global spatial analysis results and metadata of colData, rowData, and
geometries}
\usage{
colFeatureData(sfe)

rowFeatureData(sfe)

geometryFeatureData(sfe, type, MARGIN = 2L)

reducedDimFeatureData(sfe, dimred)
}
\arguments{
\item{sfe}{An SFE object.}

\item{type}{Which geometry, can be name (character) or index (integer)}

\item{MARGIN}{Integer, 1 means rowGeometry, 2 means colGeometry, and 3 means
annotGeometry. Defaults to 2, colGeometry.}

\item{dimred}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}.}
}
\value{
A \code{DataFrame}.
}
\description{
Results of spatial analyses on columns in \code{colData}, \code{rowData}, and
geometries are stored in their metadata. The \code{colFeaturedata} function
allows the users to more directly access these results.
}
\examples{
library(SpatialFeatureExperiment)
library(SingleCellExperiment)
library(SFEData)
library(Voyager)
sfe <- McKellarMuscleData("small")
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
# Moran's I for colData
sfe <- colDataMoransI(sfe, "nCounts")
colFeatureData(sfe)
}
\seealso{
getParams
}
\concept{Getters and setters}
