% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{splitByCol}
\alias{splitByCol}
\alias{splitByCol,SpatialFeatureExperiment,sf-method}
\alias{splitByCol,SpatialFeatureExperiment,sfc-method}
\alias{splitByCol,SpatialFeatureExperiment,list-method}
\alias{splitSamples}
\alias{splitContiguity}
\alias{splitComponent}
\title{Split SFE object with categorical vector or geometry}
\usage{
\S4method{splitByCol}{SpatialFeatureExperiment,sf}(x, f, sample_id = "all", colGeometryName = 1L, cover = FALSE)

\S4method{splitByCol}{SpatialFeatureExperiment,sfc}(x, f, sample_id = 1L, colGeometryName = 1L, cover = FALSE)

\S4method{splitByCol}{SpatialFeatureExperiment,list}(x, f, sample_id = "all", colGeometryName = 1L, cover = FALSE)

splitSamples(x)

splitContiguity(
  x,
  colGeometryName = 1L,
  annotGeometryName = "tissueBoundary",
  min_area = 0,
  cover = FALSE
)

splitComponent(x, colGraphName = 1L, min_cells = 100)
}
\arguments{
\item{x}{An SFE object}

\item{f}{It can be a \code{sf} data frame or \code{sfc} to split by geometry.
Each row of the \code{sf} data frame or each element in the \code{sfc} will
correspond to a new SFE object. The \code{sf} data frame must have a column
\code{sample_id} when splitting multiple samples. Can also be a list of
\code{sfc} whose names correspond to \code{sample_id}s to split.}

\item{sample_id}{Which samples to split.}

\item{colGeometryName}{Which \code{colGeometry} to use to determine which
cells or spots should belong to which new SFE object when splitting by
\code{sf} or \code{sfc}. Default to the first one.}

\item{cover}{Logical, whether the geometries in \code{x} must be entirely
covered by \code{y} if \code{op = st_intersection} or whether \code{x} must
be entirely outside \code{y} if \code{op = st_difference}. Only relevant
when \code{keep_whole != "none"}.}

\item{annotGeometryName}{Name of \code{annotGeometry} to use to split by
contiguity.}

\item{min_area}{Minimum area in the same unit as the geometry coordinates
(squared) for each piece to be considered a separate piece when splitting
by contiguity. Only pieces that are large enough are considered.}

\item{colGraphName}{Name of graph to use for \code{splitComponent}. We
recommend distance based neighbors (`dnearneigh` in 
\code{\link{findSpatialNeighbors}}), and recommend NOT using k nearest
neighbors (`knearneigh`) or triangulation (`tri2nb`).}

\item{min_cells}{Minimum number of cells per graph component; components with
fewer than this number of cells are considered debris and removed.}
}
\value{
A list of SFE objects.
}
\description{
The \code{split} methods for SFE split an SFE object into multiple SFE
objects by geometries (all cells/spots intersecting with each geometry will
become a separate SFE object). The \code{splitSamples} function splits the
SFE object by \code{sample_id} so each sample will become a separate SFE
object. The \code{splitContiguity} function splits the SFE object by
contiguity of an \code{annotGeometry}, which by default is "tissueBoundary".
The \code{splitComponent} function splits the SFE object by graph component,
so if there are disconnected components in the graph, then each component 
will become a new SFE object.
}
\examples{
# example code
}
\concept{Geometric operations}
