% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinateGeneration.R
\name{createMask}
\alias{createMask}
\title{Create a binary mask from a base 64 string}
\usage{
createMask(b64string, metadata, outline = TRUE)
}
\arguments{
\item{b64string}{base 64 string}

\item{metadata}{metadata of AOI including: Height, Width of AOI}

\item{outline}{only the outline points should be returned}
}
\value{
binary mask image
}
\description{
Create a binary mask from a base 64 string
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))

samp <- which(sampNames(muBrain) == "DSP-1012999073013-A-F12")

ROIMask <- createMask(b64string = position(overlay(muBrain))[samp], 
                      metadata = meta(overlay(muBrain))[samp,],
                      outline = TRUE)

pheatmap::pheatmap(ROIMask, cluster_rows = FALSE, cluster_cols = FALSE)

}
