% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra.R
\name{spectraData}
\alias{spectraData}
\alias{acquisitionNum}
\alias{centroided}
\alias{collisionEnergy}
\alias{dataOrigin}
\alias{dataStorage}
\alias{intensity}
\alias{ionCount}
\alias{isCentroided}
\alias{isEmpty}
\alias{isolationWindowLowerMz}
\alias{isolationWindowUpperMz}
\alias{isolationWindowTargetMz}
\alias{lengths}
\alias{msLevel}
\alias{mz}
\alias{peaksData}
\alias{peaksVariables}
\alias{polarity}
\alias{precursorCharge}
\alias{precursorIntensity}
\alias{precursorMz}
\alias{rtime}
\alias{scanIndex}
\alias{smoothed}
\alias{spectraNames}
\alias{spectraVariables}
\alias{tic}
\alias{uniqueMsLevels}
\alias{asDataFrame}
\alias{acquisitionNum,Spectra-method}
\alias{centroided,Spectra-method}
\alias{centroided<-,Spectra-method}
\alias{collisionEnergy,Spectra-method}
\alias{collisionEnergy<-,Spectra-method}
\alias{coreSpectraVariables}
\alias{dataOrigin,Spectra-method}
\alias{dataOrigin<-,Spectra-method}
\alias{dataStorage,Spectra-method}
\alias{intensity,Spectra-method}
\alias{ionCount,Spectra-method}
\alias{isCentroided,Spectra-method}
\alias{isEmpty,Spectra-method}
\alias{isolationWindowLowerMz,Spectra-method}
\alias{isolationWindowLowerMz<-,Spectra-method}
\alias{isolationWindowTargetMz,Spectra-method}
\alias{isolationWindowTargetMz<-,Spectra-method}
\alias{isolationWindowUpperMz,Spectra-method}
\alias{isolationWindowUpperMz<-,Spectra-method}
\alias{length,Spectra-method}
\alias{lengths,Spectra-method}
\alias{longForm,Spectra-method}
\alias{msLevel,Spectra-method}
\alias{mz,Spectra-method}
\alias{peaksData,Spectra-method}
\alias{peaksVariables,Spectra-method}
\alias{polarity,Spectra-method}
\alias{polarity<-,Spectra-method}
\alias{precScanNum,Spectra-method}
\alias{precursorCharge,Spectra-method}
\alias{precursorIntensity,Spectra-method}
\alias{precursorMz,Spectra-method}
\alias{precursorMz<-,Spectra-method}
\alias{rtime,Spectra-method}
\alias{rtime<-,Spectra-method}
\alias{scanIndex,Spectra-method}
\alias{smoothed,Spectra-method}
\alias{smoothed<-,Spectra-method}
\alias{spectraData,Spectra-method}
\alias{spectraData<-,Spectra-method}
\alias{spectraNames,Spectra-method}
\alias{spectraNames<-,Spectra-method}
\alias{spectraVariables,Spectra-method}
\alias{tic,Spectra-method}
\alias{uniqueMsLevels,Spectra-method}
\alias{$,Spectra-method}
\alias{$<-,Spectra-method}
\alias{[[,Spectra-method}
\alias{[[<-,Spectra-method}
\title{Accessing mass spectrometry data}
\usage{
asDataFrame(
  object,
  i = seq_along(object),
  spectraVars = spectraVariables(object)
)

\S4method{acquisitionNum}{Spectra}(object)

\S4method{centroided}{Spectra}(object)

\S4method{centroided}{Spectra}(object) <- value

\S4method{collisionEnergy}{Spectra}(object)

\S4method{collisionEnergy}{Spectra}(object) <- value

coreSpectraVariables()

\S4method{dataOrigin}{Spectra}(object)

\S4method{dataOrigin}{Spectra}(object) <- value

\S4method{dataStorage}{Spectra}(object)

\S4method{intensity}{Spectra}(object, f = processingChunkFactor(object), ...)

\S4method{ionCount}{Spectra}(object)

\S4method{isCentroided}{Spectra}(object, ...)

\S4method{isEmpty}{Spectra}(x)

\S4method{isolationWindowLowerMz}{Spectra}(object)

\S4method{isolationWindowLowerMz}{Spectra}(object) <- value

\S4method{isolationWindowTargetMz}{Spectra}(object)

\S4method{isolationWindowTargetMz}{Spectra}(object) <- value

\S4method{isolationWindowUpperMz}{Spectra}(object)

\S4method{isolationWindowUpperMz}{Spectra}(object) <- value

\S4method{length}{Spectra}(x)

\S4method{lengths}{Spectra}(x, use.names = FALSE)

\S4method{longForm}{Spectra}(
  object,
  columns = union(spectraVariables(object), peaksVariables(object))
)

\S4method{msLevel}{Spectra}(object)

\S4method{mz}{Spectra}(object, f = processingChunkFactor(object), ...)

\S4method{peaksData}{Spectra}(
  object,
  columns = c("mz", "intensity"),
  f = processingChunkFactor(object),
  return.type = c("SimpleList", "list"),
  ...,
  BPPARAM = bpparam()
)

\S4method{peaksVariables}{Spectra}(object)

\S4method{polarity}{Spectra}(object)

\S4method{polarity}{Spectra}(object) <- value

\S4method{precScanNum}{Spectra}(object)

\S4method{precursorCharge}{Spectra}(object)

\S4method{precursorIntensity}{Spectra}(object)

\S4method{precursorMz}{Spectra}(object)

\S4method{precursorMz}{Spectra}(object, ...) <- value

\S4method{rtime}{Spectra}(object)

\S4method{rtime}{Spectra}(object) <- value

\S4method{scanIndex}{Spectra}(object)

\S4method{smoothed}{Spectra}(object)

\S4method{smoothed}{Spectra}(object) <- value

\S4method{spectraData}{Spectra}(object, columns = spectraVariables(object))

\S4method{spectraData}{Spectra}(object) <- value

\S4method{spectraNames}{Spectra}(object)

\S4method{spectraNames}{Spectra}(object) <- value

\S4method{spectraVariables}{Spectra}(object)

\S4method{tic}{Spectra}(object, initial = TRUE)

\S4method{uniqueMsLevels}{Spectra}(object, ...)

\S4method{$}{Spectra}(x, name)

\S4method{$}{Spectra}(x, name) <- value

\S4method{[[}{Spectra}(x, i, j, ...)

\S4method{[[}{Spectra}(x, i, j, ...) <- value
}
\arguments{
\item{object}{A \code{Spectra} object.}

\item{i}{For \code{asDataFrame()}: A \code{numeric} indicating which scans to coerce
to a \code{DataFrame} (default is \code{seq_along(object)}).}

\item{spectraVars}{\code{character()} indicating what spectra variables to add to
the \code{DataFrame}. Default is \code{spectraVariables(object)}, i.e. all
available variables.}

\item{value}{A vector with values to replace the respective spectra
variable. Needs to be of the correct data type for the spectra variable.}

\item{f}{For \code{intensity()}, \code{mz()} and \code{peaksData()}: factor defining how
data should be chunk-wise loaded an processed. Defaults to
\code{\link[=processingChunkFactor]{processingChunkFactor()}}.}

\item{...}{Additional arguments.}

\item{x}{A \code{Spectra} object.}

\item{use.names}{For \code{lengths()}: ignored.}

\item{columns}{For \code{spectraData()} accessor: optional \code{character} with
column names (spectra variables) that should be included in the
returned \code{DataFrame}. By default, all columns are returned.
For \code{peaksData()} accessor: optional \code{character} with requested columns
in the individual \code{matrix} of the returned \code{list}. Defaults to
\code{c("mz", "value")} but any values returned by \code{peaksVariables(object)}
with \code{object} being the \code{Spectra} object are supported.
For \code{longForm()}: \code{character} with the spectra and peaks variables to
include in the returned \code{data.frame}. Defaults to
\code{union(spectraVariables(object), peaksVariables(object))}.}

\item{return.type}{For \code{peaksData()}: \code{character(1)} allowing to specify if
the results should be returned as a \code{SimpleList} or as a \code{list}.
Defaults to \code{return.type = "SimpleList"}.}

\item{BPPARAM}{Parallel setup configuration. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for more information. See also \code{\link[=processingChunkSize]{processingChunkSize()}} for more
information on parallel processing.}

\item{initial}{For \code{tic()}: \code{logical(1)} whether the initially
reported total ion current should be reported, or whether the
total ion current should be (re)calculated on the actual data
(\code{initial = FALSE}, same as \code{ionCount()}).}

\item{name}{For \code{$} and \verb{$<-}: the name of the spectra variable to return
or set.}

\item{j}{For \code{[}: not supported.}
}
\description{
As detailed in the documentation of the \link{Spectra} class, a \code{Spectra} object
is a container for mass spectrometry (MS) data that includes both the mass
peaks data (or \emph{peaks data}, generally \emph{m/z} and intensity values) as well
as spectra metadata (so called \emph{spectra variables}). Spectra variables
generally define one value per spectrum, while for peaks variables one value
per mass peak is defined and hence multiple values per spectrum (depending
on the number of mass peaks of a spectrum).

Data can be extracted from a \code{Spectra} object using dedicated accessor
functions or also using the \code{$} operator. Depending on the backend class
used by the \code{Spectra} to represent the data, data can also be added or
replaced (again, using dedicated functions or using \verb{$<-}).
}
\section{Spectra variables}{


A common set of \emph{core spectra variables} are defined for \code{Spectra}. These
have a pre-defined data type and each \code{Spectra} will return a value for
these if requested. If no value for a spectra variable is defined, a missing
value (of the correct data type) is returned. The list of core spectra
variables and their respective data type is:
\itemize{
\item \emph{acquisitionNum} \code{integer(1)}: the index of acquisition of a spectrum
during an MS run.
\item \emph{centroided} \code{logical(1)}: whether the spectrum is in profile or centroid
mode.
\item \emph{collisionEnergy} \code{numeric(1)}: collision energy used to create an MSn
spectrum.
\item \emph{dataOrigin} \code{character(1)}: the \emph{origin} of the spectrum's data, e.g. the
mzML file from which it was read.
\item \emph{dataStorage} \code{character(1)}: the (current) storage location of the
spectrum data. This value depends on the backend used to handle and
provide the data. For an \emph{in-memory} backend like the \code{MsBackendDataFrame}
this will be \code{"<memory>"}, for an on-disk backend such as the
\code{MsBackendHdf5Peaks} it will be the name of the HDF5 file where the
spectrum's peak data is stored.
\item \emph{isolationWindowLowerMz} \code{numeric(1)}: lower m/z for the isolation
window in which the (MSn) spectrum was measured.
\item \emph{isolationWindowTargetMz} \code{numeric(1)}: the target m/z for the isolation
window in which the (MSn) spectrum was measured.
\item \emph{isolationWindowUpperMz} \code{numeric(1)}: upper m/z for the isolation window
in which the (MSn) spectrum was measured.
\item \emph{msLevel} \code{integer(1)}: the MS level of the spectrum.
\item \emph{polarity} \code{integer(1)}: the polarity of the spectrum (\code{0} and \code{1}
representing negative and positive polarity, respectively).
\item \emph{precScanNum} \code{integer(1)}: the scan (acquisition) number of the precursor
for an MSn spectrum.
\item \emph{precursorCharge} \code{integer(1)}: the charge of the precursor of an MSn
spectrum.
\item \emph{precursorIntensity} \code{numeric(1)}: the intensity of the precursor of an
MSn spectrum.
\item \emph{precursorMz} \code{numeric(1)}: the m/z of the precursor of an MSn spectrum.
\item \emph{rtime} \code{numeric(1)}: the retention time of a spectrum.
\item \emph{scanIndex} \code{integer(1)}: the index of a spectrum within a (raw) file.
\item \emph{smoothed} \code{logical(1)}: whether the spectrum was smoothed.
}

For each of these spectra variable a dedicated accessor function is defined
(such as \code{msLevel()} or \code{rtime()}) that allows to extract the values of
that spectra variable for all spectra in a \code{Spectra} object. Also,
replacement functions are defined, but not all backends might support
replacing values for spectra variables. As described above, additional
spectra variables can be defined or added. The \code{spectraVariables()} function
can be used to

Values for multiple spectra variables, or all spectra vartiables* can be
extracted with the \code{spectraData()} function.
}

\section{Peaks variables}{


\code{Spectra} also provide mass peak data with the \emph{m/z} and intensity values
being the \emph{core} peaks variables:
\itemize{
\item \emph{intensity} \code{numeric}: intensity values for the spectrum's peaks.
\item \emph{mz} \code{numeric}: the m/z values for the spectrum's peaks.
}

Values for these can be extracted with the \code{mz()} and \code{intensity()}
functions, or the \code{peaksData()} function. The former functions return a
\code{NumericList} with the respective values, while the latter returns a \code{List}
with \code{numeric} two-column matrices. The list of peaks matrices can also
be extracted using \code{as(x, "list")} or \code{as(x, "SimpleList")} with \code{x} being
a \code{Spectra} object.

Some \code{Spectra}/backends provide also values for additional peaks variables.
The set of available peaks variables can be extracted with the
\code{peaksVariables()} function.
}

\section{Functions to access MS data}{


The set of available functions to extract data from, or set data in, a
\code{Spectra} object are (in alphabetical order) listed below. Note that there
are also other functions to extract information from a \code{Spectra} object
documented in \code{\link[=addProcessing]{addProcessing()}}.
\itemize{
\item \code{$}, \verb{$<-}: gets (or sets) a spectra variable for all spectra in \code{object}.
See examples for details. Note that replacing values of a peaks variable
is not supported with a non-empty processing queue, i.e. if any filtering
or data manipulations on the peaks data was performed. In these cases
\code{\link[=applyProcessing]{applyProcessing()}} needs to be called first to apply all cached data
operations.
\item \code{[[}, \verb{[[<-}: access or set/add a single spectrum variable (column) in the
backend.
\item \code{acquisitionNum()}: returns the acquisition number of each
spectrum. Returns an \code{integer} of length equal to the number of
spectra (with \code{NA_integer_} if not available).
\item \code{asDataFrame()}: converts the \code{Spectra} to a \code{DataFrame} (in long format)
contining all data. Returns a \code{DataFrame}. See also \code{longForm()} for a
potentially more efficient implementation that returns a \code{data.frame} in
long form.
\item \code{centroided()}, \verb{centroided<-}: gets or sets the centroiding
information of the spectra. \code{centroided()} returns a \code{logical}
vector of length equal to the number of spectra with \code{TRUE} if a
spectrum is centroided, \code{FALSE} if it is in profile mode and \code{NA}
if it is undefined. See also \code{isCentroided()} for estimating from
the spectrum data whether the spectrum is centroided. \code{value}
for \verb{centroided<-} is either a single \code{logical} or a \code{logical} of
length equal to the number of spectra in \code{object}.
\item \code{collisionEnergy()}, \verb{collisionEnergy<-}: gets or sets the
collision energy for all spectra in \code{object}. \code{collisionEnergy()}
returns a \code{numeric} with length equal to the number of spectra
(\code{NA_real_} if not present/defined), \verb{collisionEnergy<-} takes a
\code{numeric} of length equal to the number of spectra in \code{object}.
\item \code{coreSpectraVariables()}: returns the \emph{core} spectra variables along with
their expected data type.
\item \code{dataOrigin()}, \verb{dataOrigin<-}: gets or sets the \emph{data origin} for each
spectrum. \code{dataOrigin()} returns a \code{character} vector (same length than
\code{object}) with the origin of the spectra. \verb{dataOrigin<-} expects a
\code{character} vector (same length than \code{object}) with the replacement
values for the data origin of each spectrum.
\item \code{dataStorage()}: returns a \code{character} vector (same length than \code{object})
with the data storage location of each spectrum.
\item \code{intensity()}: gets the intensity values from the spectra. Returns
a \code{\link[IRanges:AtomicList-class]{IRanges::NumericList()}} of \code{numeric} vectors (intensity values for each
spectrum). The length of the list is equal to the number of
\code{spectra} in \code{object}.
\item \code{ionCount()}: returns a \code{numeric} with the sum of intensities for
each spectrum. If the spectrum is empty (see \code{isEmpty()}),
\code{NA_real_} is returned.
\item \code{isCentroided()}: a heuristic approach assessing if the spectra in
\code{object} are in profile or centroided mode. The function takes
the \code{qtl}th quantile top peaks, then calculates the difference
between adjacent m/z value and returns \code{TRUE} if the first
quartile is greater than \code{k}. (See \code{Spectra:::.isCentroided()} for
the code.)
\item \code{isEmpty()}: checks whether a spectrum in \code{object} is empty
(i.e. does not contain any peaks). Returns a \code{logical} vector of
length equal number of spectra.
\item \code{isolationWindowLowerMz()}, \verb{isolationWindowLowerMz<-}: gets or sets the
lower m/z boundary of the isolation window.
\item \code{isolationWindowTargetMz()}, \verb{isolationWindowTargetMz<-}: gets or sets the
target m/z of the isolation window.
\item \code{isolationWindowUpperMz()}, \verb{isolationWindowUpperMz<-}: gets or sets the
upper m/z boundary of the isolation window.
\item \code{length()}: gets the number of spectra in the object.
\item \code{lengths()}: gets the number of peaks (m/z-intensity values) per
spectrum. Returns an \code{integer} vector (length equal to the
number of spectra). For empty spectra, \code{0} is returned.
\item \code{longForm()}: extract the MS data as a \code{data.frame} in \emph{long form} with
columns being spectra and peaks variables and one row per mass peak.
Parameter \code{columns} allows to define the spectra and peaks variables that
should be included in the returned \code{data.frame} (with the default being
\verb{columns = union(spectraVariables(object), peaksVariables(object)))}.
\item \code{msLevel()}: gets the spectra's MS level. Returns an integer vector (names
being spectrum names, length equal to the number of spectra) with the MS
level for each spectrum.
\item \code{mz()}: gets the mass-to-charge ratios (m/z) from the
spectra. Returns a \code{\link[IRanges:AtomicList-class]{IRanges::NumericList()}} or length equal to the number
of spectra, each element a \code{numeric} vector with the m/z values of
one spectrum.
\item \code{peaksData()}: gets the \emph{peaks} data for all spectra in \code{object}. Peaks
data consist of the m/z and intensity values as well as possible additional
annotations (variables) of all peaks of each spectrum. The function
returns a \code{\link[S4Vectors:SimpleList-class]{S4Vectors::SimpleList()}} of two dimensional arrays (either
\code{matrix} or \code{data.frame}), with each array providing the values for the
requested \emph{peak variables} (by default \code{"mz"} and \code{"intensity"}).
Optional parameter \code{columns} is passed to the backend's \code{peaksData()}
function to allow the selection of specific (or additional) peaks
variables (columns) that should be extracted (if available). Importantly,
it is \strong{not} guaranteed that each backend supports this parameter (while
each backend must support extraction of \code{"mz"} and \code{"intensity"} columns).
Parameter \code{columns} defaults to \code{c("mz", "intensity")} but any value
returned by \code{peaksVariables(object)} is supported.
Note also that it is possible to extract the peak data with
\code{as(x, "list")} and \code{as(x, "SimpleList")} as a \code{list} and \code{SimpleList},
respectively. Note however that, in contrast to \code{peaksData()}, \code{as()}
does not support the parameter \code{columns}.
\item \code{peaksVariables()}: lists the available variables for mass peaks provided
by the backend. Default peak variables are \code{"mz"} and \code{"intensity"} (which
all backends need to support and provide), but some backends might provide
additional variables.
These variables correspond to the column names of the peak data array
returned by \code{peaksData()}.
\item \code{polarity()}, \verb{polarity<-}: gets or sets the polarity for each
spectrum. \code{polarity()} returns an \code{integer} vector (length equal
to the number of spectra), with \code{0} and \code{1} representing negative
and positive polarities, respectively. \verb{polarity<-} expects an
\code{integer} vector of length 1 or equal to the number of spectra.
\item \code{precursorCharge()}, \code{precursorIntensity()}, \code{precursorMz()},
\code{precScanNum()}, \code{precAcquisitionNum()}: gets the charge (\code{integer}),
intensity (\code{numeric}), m/z (\code{numeric}), scan index (\code{integer})
and acquisition number (\code{interger}) of the precursor for MS level >
2 spectra from the object. Returns a vector of length equal to
the number of spectra in \code{object}. \code{NA} are reported for MS1
spectra of if no precursor information is available.
\item \code{rtime()}, \verb{rtime<-}: gets or sets the retention times (in seconds)
for each spectrum.  \code{rtime()} returns a \code{numeric} vector (length
equal to the number of spectra) with the retention time for each
spectrum.  \verb{rtime<-} expects a numeric vector with length equal
to the number of spectra.
\item \code{scanIndex()}: returns an \code{integer} vector with the \emph{scan index}
for each spectrum. This represents the relative index of the
spectrum within each file. Note that this can be different to the
\code{acquisitionNum} of the spectrum which represents the index of the
spectrum during acquisition/measurement (as reported in the mzML file).
\item \code{smoothed()},\verb{smoothed<-}: gets or sets whether a spectrum is
\emph{smoothed}. \code{smoothed()} returns a \code{logical} vector of length equal
to the number of spectra. \verb{smoothed<-} takes a \code{logical} vector
of length 1 or equal to the number of spectra in \code{object}.
\item \code{spectraData()}: gets general spectrum metadata (annotation, also called
header). \code{spectraData()} returns a \code{DataFrame}. Note that this
method does by default \strong{not} return m/z or intensity values.
\item \verb{spectraData<-}: \strong{replaces} the full spectra data of the \code{Spectra}
object with the one provided with \code{value}. The \verb{spectraData<-} function
expects a \code{DataFrame} to be passed as value with the same number of rows
as there a spectra in \code{object}. Note that replacing values of
peaks variables is not supported with a non-empty processing queue, i.e.
if any filtering or data manipulations on the peaks data was performed.
In these cases \code{\link[=applyProcessing]{applyProcessing()}} needs to be called first to apply all
cached data operations and empty the processing queue.
\item \code{spectraNames()}, \verb{spectraNames<-}: gets or sets the spectra names.
\item \code{spectraVariables()}: returns a \code{character} vector with the
available spectra variables (columns, fields or attributes of each
spectrum) available in \code{object}. Note that \code{spectraVariables()} does not
list the \emph{peak variables} (\code{"mz"}, \code{"intensity"} and eventual additional
annotations for each MS peak). Peak variables are returned by
\code{peaksVariables()}.
\item \code{tic()}: gets the total ion current/count (sum of signal of a
spectrum) for all spectra in \code{object}. By default, the value
reported in the original raw data file is returned. For an empty
spectrum, \code{0} is returned.
\item \code{uniqueMsLevels()}: get the unique MS levels available in \code{object}. This
function is supposed to be more efficient than \code{unique(msLevel(object))}.
}
}

\examples{

## Create a Spectra from mzML files and use the `MsBackendMzR` on-disk
## backend.
sciex_file <- dir(system.file("sciex", package = "msdata"),
    full.names = TRUE)
sciex <- Spectra(sciex_file, backend = MsBackendMzR())
sciex

## Get the number of spectra in the data set
length(sciex)

## Get the number of mass peaks per spectrum - limit to the first 6
lengths(sciex) |> head()

## Get the MS level for each spectrum - limit to the first 6 spectra
msLevel(sciex) |> head()

## Alternatively, we could also use $ to access a specific spectra variable.
## This could also be used to add additional spectra variables to the
## object (see further below).
sciex$msLevel |> head()

## Get the intensity and m/z values.
intensity(sciex)
mz(sciex)

## Convert a subset of the Spectra object to a long DataFrame.
asDataFrame(sciex, i = 1:3, spectraVars = c("rtime", "msLevel"))

## Create a Spectra providing a `DataFrame` containing the spectrum data.

spd <- DataFrame(msLevel = c(1L, 2L), rtime = c(1.1, 1.2))
spd$mz <- list(c(100, 103.2, 104.3, 106.5), c(45.6, 120.4, 190.2))
spd$intensity <- list(c(200, 400, 34.2, 17), c(12.3, 15.2, 6.8))

s <- Spectra(spd)
s

## List all available spectra variables (i.e. spectrum data and metadata).
spectraVariables(s)

## For all *core* spectrum variables accessor functions are available. These
## return NA if the variable was not set.
centroided(s)
dataStorage(s)
rtime(s)
precursorMz(s)

## The core spectra variables are:
coreSpectraVariables()

## Add an additional metadata column.
s$spectrum_id <- c("sp_1", "sp_2")

## List spectra variables, "spectrum_id" is now also listed
spectraVariables(s)

## Get the values for the new spectra variable
s$spectrum_id

## Extract specific spectra variables.
spectraData(s, columns = c("spectrum_id", "msLevel"))


##  --------  PEAKS VARIABLES AND DATA  --------

## Get the peak data (m/z and intensity values).
pks <- peaksData(s)
pks
pks[[1]]
pks[[2]]

## Note that we could get the same resulb by coercing the `Spectra` to
## a `list` or `SimpleList`:
as(s, "list")
as(s, "SimpleList")

## Or use `mz()` and `intensity()` to extract the m/z and intensity values
## separately
mz(s)
intensity(s)

## Some `MsBackend` classes provide support for arbitrary peaks variables
## (in addition to the mandatory `"mz"` and `"intensity"` values. Below
## we create a simple data frame with an additional peak variable `"pk_ann"`
## and create a `Spectra` with a `MsBackendMemory` for that data.
## Importantly the number of values (per spectrum) need to be the same
## for all peak variables.

tmp <- data.frame(msLevel = c(2L, 2L), rtime = c(123.2, 123.5))
tmp$mz <- list(c(103.1, 110.4, 303.1), c(343.2, 453.1))
tmp$intensity <- list(c(130.1, 543.1, 40), c(0.9, 0.45))
tmp$pk_ann <- list(c(NA_character_, "A", "P"), c("B", "P"))

## Create the Spectra. With parameter `peaksVariables` we can define
## the columns in `tmp` that contain peaks variables.
sps <- Spectra(tmp, source = MsBackendMemory(),
    peaksVariables = c("mz", "intensity", "pk_ann"))
peaksVariables(sps)

## Extract just the m/z and intensity values
peaksData(sps)[[1L]]

## Extract the full peaks data
peaksData(sps, columns = peaksVariables(sps))[[1L]]

## Access just the pk_ann variable
sps$pk_ann


}
\seealso{
\itemize{
\item \code{\link[=addProcessing]{addProcessing()}} for functions to analyze \code{Spectra}.
\item \link{Spectra} for a general description of the \code{Spectra} object.
}
}
\author{
Sebastian Gibb, Johannes Rainer, Laurent Gatto, Philippine Louail
}
