% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_genes.R
\name{select_genes}
\alias{select_genes}
\title{Select genes using AutoGeneS}
\usage{
select_genes(scRNAseq, fixed_n_features = NA, n_hvg_genes = 3000L, labels)
}
\arguments{
\item{scRNAseq}{SingleCellExperiment object to use for gene selection, should
be same as signature dataset}

\item{fixed_n_features}{integer number of genes to pick with autogenes,
default is NA which lets autogenes itself pick}

\item{n_hvg_genes}{int which allows the users to choose the number of highly
variable genes}

\item{labels}{character vector with cell type labels}
}
\value{
Vector of genes to use for deconvolution
}
\description{
\code{select_genes.R} select genes using AutoGeneS for deconvolution
}
\examples{
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(scRNAseq)
    library(scuttle)
    ## Load SegerstolpePancreas data set
    scRNAseq <- SegerstolpePancreasData()

    ## remove duplicate genes
    scRNAseq <- scRNAseq[!duplicated(rownames(scRNAseq)), ]

    ## Subset to 1 healthy and 2 type 2 diabetes samples
    scRNAseq <- scRNAseq[, scRNAseq$individual \%in\% c(
        "H3",
        "T2D1", "T2D2"
    )]
    ## remove cells with no cell type label
    scRNAseq <- scRNAseq[, !is.na(scRNAseq$`cell type`)]

    ## remove rare cell types (<100 cells in total data set)
    celltypes_to_remove <-names(table(scRNAseq$`cell type`)
        [(table(scRNAseq$`cell type`) < 100)])
    scRNAseq <- scRNAseq[, !scRNAseq$`cell type` \%in\% celltypes_to_remove]

    ## remove NA cells
    scRNAseq <- scRNAseq[, !is.na(scRNAseq$`cell type`)]

    ## Normalize (cp10k) and logtransform scRNAseq
    cpm(scRNAseq) <- scuttle::calculateCPM(scRNAseq)
    logcounts(scRNAseq) <- log1p(cpm(scRNAseq) / 100)

    ## Select genes by autogenes
    selected_genes <- select_genes(scRNAseq, 3L,
        n_hvg_genes = 5L,
        labels = scRNAseq$`cell type`
    ) # 3 genes
}
}
