% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statial.R
\name{plotStateChanges}
\alias{plotStateChanges}
\title{Visualise Cell-Cell Marker Relationships}
\usage{
plotStateChanges(
  cells,
  image,
  from,
  to,
  marker,
  type = "distances",
  assay = 1,
  cellType = "cellType",
  imageID = "imageID",
  spatialCoords = c("x", "y"),
  size = 1,
  shape = 19,
  interactive = FALSE,
  plotModelFit = FALSE,
  method = "lm"
)
}
\arguments{
\item{cells}{A SingleCellExperiment that has had distances already calculated.}

\item{image}{An image to subset to.}

\item{from}{A character indicating the name of the cell type (from the cellType column) whose cell state is being investigated in}

\item{to}{A character indicating the name of the cell type (from the cellType column) who may be influencing the cell state of another cell type}

\item{marker}{The marker of interest.}

\item{type}{The name of the reduced dimension to use for the x-axis.}

\item{assay}{Name of the assay that stores the marker expression.}

\item{cellType}{The name of the column in colData that stores the cell types.}

\item{imageID}{The name of the column in colData that stores the image ids.}

\item{spatialCoords}{The names of the columns in colData that store the spatial coordinates.}

\item{size}{Aesthetic numerical variable determining the size of the displayed cells}

\item{shape}{Aesthetic variable determining the shape grouping of the displayed cells}

\item{interactive}{Logical indicating if the output visualisation should be a interactive (plotly)}

\item{plotModelFit}{Logical indicating if fitted values should be plotted or actual intensities for marker specified. The default is to plot actual intensities}

\item{method}{The method to build the model with. Currently the only option is "lm". However, capabilities may be expanded in the future}
}
\description{
Helper functions to visualise OLS model fits for image based state models
}
\details{
image,
}
\examples{
library(dplyr)
data("kerenSCE")

kerenSCE <- getDistances(kerenSCE)

p <- plotStateChanges(
  cells = kerenSCE,
  type = "distances",
  image = "6",
  from = "Keratin_Tumour",
  to = "Macrophages",
  marker = "p53",
  size = 1,
  shape = 19,
  interactive = FALSE,
  plotModelFit = FALSE,
  method = "lm"
)

p

}
