% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotate_SPID.R
\name{Annotate_SPID}
\alias{Annotate_SPID}
\title{Annotate_SPID}
\usage{
Annotate_SPID(
  DGE,
  enrich.database = "WikiPathway_2021_Human",
  output_tsv = FALSE
)
}
\arguments{
\item{DGE}{Data.frame containing annotated DEG list, as the output of DGE or Gene2SProtein functions.}

\item{enrich.database}{String containing the EnrichR databases you would like to consult. Default: WikiPathway_2021_Human.}

\item{output_tsv}{Logical. If \code{TRUE}, outputs a tsv file with the results. By default, FALSE.}
}
\value{
A dataframe with surface protein coding \code{DEGs} annotation.
}
\description{
Annotate Surface Protein Coding genes according to EnrichR libraries
}
\section{Warning}{

Be sure that enrich.database exists.
}

\examples{
\dontrun{
# Deseq2 output sample
DGE = data.frame(GeneID = c("DLK1", "TOP2A"),
                 Mean_CPM_T = c(5.92, 9.91),
                 Mean_CPM_C = c(0.04, 0.03),
                 log2FoldChange = c(10.22, 8.42),
                 lfcSE = c(0.80, 0.48),
                 stat = c(12.68, 17.69),
                 pvalue = c(7.30135e-37, 4.37011e-70),
                 padj = c(1.49936e-35, 1.12976e-67))
annotated_DGE = Annotate_SPID(DGE, "WikiPathway_2021_Human")

# Output of Gene2SProtein function
GeneNames = c("CIITA", "EPCAM", "DLK1", "CD24")
SurfaceProteins_df = Gene2SProtein(GeneNames, input_type = "gene_name")
annotated_SP = Annotate_SPID(SurfaceProteins_df, "GO_Biological_Process_2021")}
}
\seealso{
\code{\link{DGE}} function for DGE,
and \code{\link{Gene2SProtein}} function for Gene2SProtein analysis

Other functional-annotation functions: 
\code{\link{Enrichment_barplot}()},
\code{\link{Enrichment}()}
}
\concept{functional-annotation functions}
