% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGA_download.R
\name{TCGA_download}
\alias{TCGA_download}
\title{TCGA_download function}
\usage{
TCGA_download(
  project,
  whichcounts = "unstranded",
  save.matrix = FALSE,
  save.metadata = FALSE,
  barcodes = NULL
)
}
\arguments{
\item{project, }{Character. A valid project from TCGAbiolinks:::getGDCprojects()$project_id}

\item{whichcounts}{Character. Counts data to use. Choose from: unstranded, stranded_first,stranded_second. By default, unstranded.}

\item{save.matrix}{Logical. If \code{TRUE}, outputs a tsv file with the Matrix. By default, FALSE.}

\item{save.metadata}{Logical. If \code{TRUE}, outputs a tsv file with the metadata. By default, FALSE.}

\item{barcodes}{Character. A vector with names of the barcodes you want to download. If NULL (default) it downloads all the available barcodes in the project.}
}
\value{
A list containing the Matrix and the metadata.
}
\description{
Downloads count matrix data from TCGA
}
\examples{
\dontrun{
GBM_list_s1 <- TCGA_download(project="TCGA-GBM",
                             whichcounts = "unstranded",
                             save.matrix = FALSE, save.metadata = FALSE,
                             barcodes = c("TCGA-06-0878-01A-01R-1849-01"))
remove downloaded data from TCGA
unlink('GDCdata', recursive = TRUE, force = TRUE)
file.remove("MANIFEST.txt")
}
}
\seealso{
Other public-data functions: 
\code{\link{DownloadArchS4}()},
\code{\link{GEOmetadata}()}
}
\concept{public-data functions}
