% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareSummarizedExperimentTensor.R
\name{PrepareSummarizedExperimentTensor}
\alias{PrepareSummarizedExperimentTensor}
\title{Title
Generate feature values formatted as a tensor format}
\usage{
PrepareSummarizedExperimentTensor(
  sample,
  feature,
  value,
  featureRange = GRanges(NULL),
  sampleData = list(NULL)
)
}
\arguments{
\item{sample}{Sample names}

\item{feature}{Feature id names}

\item{value}{Feature values}

\item{featureRange}{Genomic coordinate attributed to feature id (if any)}

\item{sampleData}{Sample property (labels etc)}
}
\value{
A tensor including sample names, feature id,
feature values, associated with featureRange and sample properties
}
\description{
Title
Generate feature values formatted as a tensor format
}
\examples{
require(GenomicRanges)
Z <- PrepareSummarizedExperimentTensor(
sample=matrix(as.character(seq_len(6)),c(3,2)),
feature=as.character(seq_len(10)),
 value=array(runif(10*3*2),c(10,3,2)))
}
