% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeHosvd.R
\name{computeHosvd}
\alias{computeHosvd}
\title{Title
Compute higher order singular value decomposition}
\usage{
computeHosvd(Z, dims = c(10, dim(attr(Z, "value"))[-1]), scale = TRUE)
}
\arguments{
\item{Z}{array that includes omics data}

\item{dims}{dimensions to be computed by HOSVD}

\item{scale}{If value is scaled}
}
\value{
List that includes output from HOSVD
}
\description{
Title
Compute higher order singular value decomposition
}
\examples{
Z <- PrepareSummarizedExperimentTensor(
sample=matrix(as.character(seq_len(6)),c(3,2)),
feature=as.character(seq_len(10)),
value=array(runif(10*3*2),c(10,3,2)))
HOSVD <- computeHosvd(Z)
}
