% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step7LinkedDNAMethylationSiteCountHistograms.R
\name{step7LinkedDNAMethylationSiteCountHistograms}
\alias{step7LinkedDNAMethylationSiteCountHistograms}
\title{Create histograms displaying the number of total genes and transcription
factor genes linked to a given number of RE DNA methylation sites}
\usage{
step7LinkedDNAMethylationSiteCountHistograms(
  TENETMultiAssayExperiment,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such as
one created by the TCGADownloader function. The object's metadata
must contain the results from the \code{step6DNAMethylationSitesPerGeneTabulation}
function.}

\item{hypermethGplusAnalysis}{Set to TRUE to create histograms of genes
linked to hypermethylated RE DNA methylation sites with G+ links. Defaults
to TRUE.}

\item{hypomethGplusAnalysis}{Set to TRUE to create histograms of genes
linked to hypomethylated RE DNA methylation sites with G+ links. Defaults to
TRUE.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list named
'step7LinkedDNAMethylationSiteCountHistograms' in its metadata, which is
subdivided into \code{hypermethGplus} and/or \code{hypomethGplus} lists as selected by
the user. Each of these contains histograms displaying the number of total
genes and TF genes linked to a given number of RE DNA methylation sites in
each of the selected analysis quadrants.
}
\description{
This function generates histograms displaying the number of total genes and
transcription factor genes linked to a given number of RE DNA methylation
sites. These are designed to highlight the top overall genes and TF genes,
which likely have a disproportionately large number of linked RE DNA
methylation sites compared to most genes.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to create histograms displaying the number of
## total genes and TF genes linked to a given number of hyper- and
## hypomethylated G+ RE DNA methylation sites.
## Since we performed analyses using only TFs in the step 3 function, the
## top genes are all TFs, so a message that separate output for
## TFs will be skipped is displayed.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create the RE DNA methylation site count
## histograms
returnValue <- step7LinkedDNAMethylationSiteCountHistograms(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example does the same, but only analyzes hypomethylated G+ RE DNA
## methylation sites.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create the RE DNA methylation site count
## histogram
returnValue <- step7LinkedDNAMethylationSiteCountHistograms(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE
)
\dontshow{\}) # examplesIf}
}
