\name{ChooseMarker}
\alias{ChooseMarker}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Choose cell type-specific markers from
pure cell type profiles or single cell data
}
\description{
Choose cell type-specific markers from pure
cell type profiles generated by microarray or RNA-seq,
or from single cell RNA-seq data by differential
analysis.
}
\usage{
ChooseMarker(pure_all, CellType, nMarkCT = 10, chooseSig = FALSE, verbose = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pure_all}{
   Input pure cell type profile matrix or single cell data matrix.
   Rows are for genes, columns are for cell types or cells.
}
  \item{CellType}{
   A list object consisting of cell type information for columns
   in pure_all. Each element is a cell type, and contains the corresponding
   column number in pure_all matrix. For example,
   CellType = list(BCell = 1:3, CD4T = 4:5).
}
  \item{nMarkCT}{
   Number of markers chosen per cell type. Default is 10.
}
  \item{chooseSig}{
   A boolean variable representing whether to consider the
   significance of selected markers. When
   chooseSig = FALSE, all nMarkerCT number of markers will be chosen
   per cell type. Otherwise the non-significant (p value > 0.05) markers
   will be filtered out.
}
  \item{verbose}{
   A boolean variable of whether to output messages.
}
}
\details{
Here we provide more details for CellType variable. This variable should be a list, with each element being the corresponding column numbers in pure_all for each cell type. For example, suppose pure_all is a 1000 by 300 matrix with row being genes and column being cells (or cell types). The first 1 to 100 columns are cell A, 101 to 200 columns are cell B, and 201 to 300 columns are cell C. Then CellType should be assigned as CellType = list(A = 1:100, B = 101:200, C = 201:300). If pure_all only has three columns for three cell types A, B and C, then CellType = list(A = 1, B = 2, C = 3).
}
\value{
A list variable, including the selected variables for all cell types.
}
\references{
Ziyi Li, Zhenxing Guo, Ying Cheng, Peng Jin, Hao Wu.
"Robust partial reference-free cell compoisiton estimation
from tissue expression profiles."
}
\author{
Ziyi Li <zli16@mdanderson.org>
}
\examples{
## randomly simulate pure cell type profiles
pure_all <- matrix(abs(rnorm(1000*9)), 1000, 9)
CellType <- list(CellA = 1:3,
                 CellB = 4:6,
                 CellC = 7:9)

## choose significant markers
SelMarker <- ChooseMarker(pure_all, CellType,
                         nMarkCT = 30,
                         chooseSig = TRUE,
                         verbose = FALSE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }% use one of  RShowDoc("KEYWORDS")
