% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_bootstrap_funcs.R
\name{bootstrapNull}
\alias{bootstrapNull}
\title{Bootstrap null distribution of F statistics for FDR estimation}
\usage{
bootstrapNull(
  df,
  maxit = 500,
  independentFiltering = FALSE,
  fcThres = 1.5,
  minObs = 20,
  optim_fun_h0 = .min_RSS_h0,
  optim_fun_h1 = .min_RSS_h1_slope_pEC50,
  optim_fun_h1_2 = NULL,
  gr_fun_h0 = NULL,
  gr_fun_h1 = NULL,
  gr_fun_h1_2 = NULL,
  ncores = 1,
  B = 20,
  byMsExp = TRUE
)
}
\arguments{
\item{df}{tidy data_frame retrieved after import of a 2D-TPP 
dataset, potential filtering and addition of a column "nObs"
containing the number of observations per protein}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}

\item{independentFiltering}{boolean flag indicating whether
independent filtering should be performed based on minimal
fold changes per protein profile}

\item{fcThres}{numeric value of minimal fold change 
(or inverse fold change) a protein has to show to be kept 
upon independent filtering}

\item{minObs}{numeric value of minimal number of observations
that should be required per protein}

\item{optim_fun_h0}{optimization function that should be used
for fitting the H0 model}

\item{optim_fun_h1}{optimization function that should be used
for fitting the H1 model}

\item{optim_fun_h1_2}{optional additional optimization function 
that will be run with paramters retrieved from optim_fun_h1 and 
should be used for fitting the H1 model with the trimmed sum
model, default is NULL}

\item{gr_fun_h0}{optional gradient function for optim_fun_h0,
default is NULL}

\item{gr_fun_h1}{optional gradient function for optim_fun_h1,
default is NULL}

\item{gr_fun_h1_2}{optional gradient function for optim_fun_h1_2,
default is NULL}

\item{ncores}{numeric value of numbers of cores that the function 
should use to parallelize}

\item{B}{numeric value of rounds of bootstrap, default: 20}

\item{byMsExp}{boolean flag indicating whether resampling of 
residuals should be performed separately for data generated by 
different MS experiments, default TRUE, recommended}
}
\value{
data frame containing F statistics of proteins with 
permuted 2D thermal profiles that are informative on the Null
distribution of F statistics
}
\description{
Bootstrap null distribution of F statistics for FDR estimation
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:3)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
boot_df <- bootstrapNull(temp_df, B = 2/10)  

}
