% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_analysis.R
\name{runTPP2D}
\alias{runTPP2D}
\title{Run complete TPP2D analysis}
\usage{
runTPP2D(
  df = NULL,
  configTable = NULL,
  data = NULL,
  idVar = "protein_id",
  intensityStr = "signal_sum_",
  fcStr = "rel_fc_",
  nonZeroCols = "qusm",
  geneNameVar = "gene_name",
  addCol = NULL,
  qualColName = "qupm",
  naStrs = c("NA", "n/d", "NaN"),
  concFactor = 1e+06,
  medianNormalizeFC = TRUE,
  filterContaminants = TRUE,
  recomputeSignalRatios = FALSE,
  minObs = 20,
  independentFiltering = FALSE,
  fcThres = 1.5,
  optim_fun_h0 = .min_RSS_h0,
  optim_fun_h1 = .min_RSS_h1_slope_pEC50,
  optim_fun_h1_2 = NULL,
  gr_fun_h0 = NULL,
  gr_fun_h1 = NULL,
  gr_fun_h1_2 = NULL,
  slopEC50 = TRUE,
  maxit = 750,
  BPPARAM = BiocParallel::SerialParam(progressbar = TRUE),
  B = 20,
  byMsExp = TRUE,
  alpha = 0.1
)
}
\arguments{
\item{df}{tidy data_frame retrieved after import of a 2D-TPP 
dataset, potential filtering and addition of a column "nObs"
containing the number of observations per protein}

\item{configTable}{character string of a file path to a config table}

\item{data}{possible list of datasets from different MS runs 
corresponding to a 2D-TPP dataset, circumvents loading datasets 
referencend in config table, default is NULL}

\item{idVar}{character string indicating which data column provides the 
unique identifiers for each protein.}

\item{intensityStr}{character string indicating which columns contain 
raw intensities measurements}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the suffix \code{fcStr} 
will be regarded as containing fold change values.}

\item{nonZeroCols}{column like default qssm that should be imported and
requested to be non-zero in analyzed data}

\item{geneNameVar}{character string of the column name that describes
the gene name of a given protein in the raw data files}

\item{addCol}{character string indicating additional column to import}

\item{qualColName}{character string indicating which column can be used for 
additional quality criteria when deciding between different non-unique 
protein identifiers.}

\item{naStrs}{character vector indicating missing values in the data table. 
When reading data from file, this value will be passed on to the argument 
\code{na.strings} in function \code{read.delim}.}

\item{concFactor}{numeric value that indicates how concentrations need to 
be adjusted to yield total unit e.g. default mmol - 1e6}

\item{medianNormalizeFC}{perform median normalization (default: TRUE).}

\item{filterContaminants}{logical variable indicating whether data 
should be filtered to exclude contaminants (default: TRUE).}

\item{recomputeSignalRatios}{logical variable indicaiting whether 
signals should be recomputed from relative fold changes, recommended
if Isobarquant was used for protein quantification}

\item{minObs}{number of minimal observations per protein to include it
in the analysis}

\item{independentFiltering}{logical variable indicating whether
independent filtering should be performed based on minimal
fold changes per protein profile}

\item{fcThres}{numeric value of minimal fold change 
(or inverse fold change) a protein has to show to be kept 
upon independent filtering}

\item{optim_fun_h0}{optimization function that should be used
for fitting the H0 model}

\item{optim_fun_h1}{optimization function that should be used
for fitting the H1 model}

\item{optim_fun_h1_2}{optional additional optimization function 
that will be run with paramters retrieved from optim_fun_h1 and 
should be used for fitting the H1 model with the trimmed sum
model, default is NULL}

\item{gr_fun_h0}{optional gradient function for optim_fun_h0,
default is NULL}

\item{gr_fun_h1}{optional gradient function for optim_fun_h1,
default is NULL}

\item{gr_fun_h1_2}{optional gradient function for optim_fun_h1_2,
default is NULL}

\item{slopEC50}{logical flag indicating whether the h1 model is
fitted with a linear model describing the shift od the pEC50 over 
temperatures}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}

\item{BPPARAM}{= BiocParallel::SerialParam(progressbar = TRUE),}

\item{B}{numeric value indicating number of rounds of bootstraps
that should be performed to estimate the null distribution}

\item{byMsExp}{logical indicating whether bootstrapping should be
performed within MS experiments}

\item{alpha}{FDR level that should be controlled}
}
\value{
a tpp2dExperiment object
}
\description{
Run complete TPP2D analysis
}
\examples{
data("simulated_cell_extract_df")
runTPP2D(df = simulated_cell_extract_df \%>\% 
   filter(representative \%in\% 1:3),
   B = 1)

}
