% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dCreateReport.R
\name{tpp2dCreateReport}
\alias{tpp2dCreateReport}
\title{Create Report of 2D-TPP analysis}
\usage{
tpp2dCreateReport(
  data = NULL,
  configFile = NULL,
  resultPath = NULL,
  documentType = "html_document",
  configTable = NULL,
  normalize = TRUE,
  methods = c(""),
  idVar = "gene_name",
  fcStr = "rel_fc_",
  fcStrUpdated = "norm_rel_fc_",
  intensityStr = "signal_sum_",
  addCol = NULL,
  fcTolerance = NA,
  r2Cutoff = NA,
  fcCutoff = NA,
  slopeBounds = c(NA, NA),
  fTest = FALSE,
  trRef = "none"
)
}
\arguments{
\item{data}{output data frame from an 2D-TPP analysis}

\item{configFile}{character string containing a valid system path to a file which summarizes 
the experimental details of the 2D-TPP experiment or respective data frame}

\item{resultPath}{character string containing a system path to where the report should be 
written}

\item{documentType}{character string indicating which document type the report should have
default: "html_document", alternatives: "pdf_document"}

\item{configTable}{data frame summarizing the experimental details of the 2D-TPP experiment}

\item{normalize}{boolean flag indicating whether median normalization has been performed}

\item{methods}{vector of characters which indicate which methods have been used}

\item{idVar}{unique protein identifier prefix}

\item{fcStr}{fold change identifier prefix}

\item{fcStrUpdated}{character string matching the fold change columns after normalization has
been performed}

\item{intensityStr}{intensity values prefix}

\item{addCol}{vector of strings indicating which additional data columns were imported}

\item{fcTolerance}{tolerance for the fcCutoff parameter}

\item{r2Cutoff}{Quality criterion on dose response curve fit.}

\item{fcCutoff}{Cutoff for highest compound concentration fold change}

\item{slopeBounds}{Bounds on the slope parameter for dose response curve 
fitting}

\item{fTest}{boolean variable stating whether an fTest was performed}

\item{trRef}{character string containing a valid system path to a previously generated TPP-TR
reference object}
}
\value{
A pdf or html report which summarizes all parameters that were set
}
\description{
Creates a markdown pdf file that summarizes the 2D-TPP analysis by reporting e.g. R
 version and package versions used
}
