% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dImport.R
\name{tpp2dImport}
\alias{tpp2dImport}
\title{Import 2D-TPP data}
\usage{
tpp2dImport(
  configTable = NULL,
  data = NULL,
  idVar = "gene_name",
  addCol = NULL,
  intensityStr = "signal_sum_",
  qualColName = "qupm",
  nonZeroCols = "qssm",
  fcStr = NULL
)
}
\arguments{
\item{configTable}{dataframe, or character object with the path to a file, 
that specifies important details of the 2D-TPP experiment. See Section 
\code{details} for instructions how to create this object.}

\item{data}{single dataframe, containing raw measurements and if already available fold
changes and additional annotation columns to be imported. Can be used instead of 
specifying the file path in the \code{configTable} argument.}

\item{idVar}{character string indicating which data column provides the 
unique identifiers for each protein.}

\item{addCol}{additional column names that specify columns in the input data that are 
to be attached to the data frame throughout the analysis}

\item{intensityStr}{character string indicating which columns contain the actual 
sumionarea values. Those column names containing the suffix \code{intensityStr} 
will be regarded as containing sumionarea values.}

\item{qualColName}{character string indicating which column can be used for 
additional quality criteria when deciding between different non-unique 
protein identifiers.}

\item{nonZeroCols}{character string indicating a column that will be used for
filtering out zero values.}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the suffix \code{fcStr} 
will be regarded as containing fold change values.}
}
\value{
A dataframe comprising all experimental data
}
\description{
Imports data from 2D-TPP experiments by parsing a configTable and reading in 
  corresponding data file or data frames containing raw data (sumionarea values) and creating a 
  big data frame comprising all samples with respective fold changes
}
\examples{
# Preparation:
data(panobinostat_2DTPP_smallExample)

# Import data:
datIn <- tpp2dImport(configTable = panobinostat_2DTPP_config,
                      data = panobinostat_2DTPP_data,
                      idVar = "representative",
                      addCol = "clustername",
                      intensityStr = "sumionarea_protein_",
                      nonZeroCols = "qusm")

# View attributes of imported data (experiment infos and import arguments):
attr(datIn, "importSettings") \%>\% unlist
attr(datIn, "configTable")

}
