% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tppccrNormalize.R
\name{tppccrNormalize}
\alias{tppccrNormalize}
\title{Normalize data from TPP-CCR experiments}
\usage{
tppccrNormalize(data)
}
\arguments{
\item{data}{list of expressionSets with measurements to be normalized}
}
\value{
List of expressionSet objects storing the normalized fold changes, as well as 
  row and column metadata. In each expressionSet \code{S}, the fold changes
  can be accessed by \code{Biobase::exprs(S)}. Protein names can be accessed by 
  \code{featureNames(S)}. Isobaric labels and the corresponding concentrations are 
  returned by \code{S$label} and \code{S$concentration}.
}
\description{
Normalize each fold change column by its median.
}
\examples{
data(hdacCCR_smallExample)
tppccrData <- tppccrImport(configTable=hdacCCR_config, data = hdacCCR_data)
tppccrNorm <- tppccrNormalize(data=tppccrData)
head(Biobase::exprs(tppccrNorm[[1]]))

}
