% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaxSEA.R
\name{TaxSEA}
\alias{TaxSEA}
\title{TaxSEA: Taxon Set Enrichment Analysis}
\usage{
TaxSEA(
  taxon_ranks = NULL,
  input_taxa = NULL,
  mode = NULL,
  lookup_missing = FALSE,
  min_set_size = 5,
  max_set_size = 300,
  custom_db = NULL
)
}
\arguments{
\item{taxon_ranks}{Named numeric vector of statistics 
(e.g., log2 fold changes).
  Required for enrichment.}

\item{input_taxa}{Character vector of taxa to treat as 
"hits"/selected taxa.
  Required for ORA.}

\item{mode}{Character. One of \code{"enrichment"} or \code{"ora"}.
If NULL, inferred from which input is provided.}

\item{lookup_missing}{Logical indicating whether to fetch
missing NCBI IDs.
 Default is FALSE.}

\item{min_set_size}{Minimum size of taxon sets to include
in the analysis.
 Default is 5.}

\item{max_set_size}{Maximum size of taxon sets to include
in the analysis.
 Default is 100.}

\item{custom_db}{A user-provided list of taxon sets. 
If NULL (default),
  the built-in database is used.}
}
\value{
A list of data frames with taxon set results.
}
\description{
Modular TaxSEA implementation supporting enrichment (KS) and 
ORA (Fisher).
Provide either \code{taxon_ranks} for enrichment or 
\code{input_taxa} for ORA.
}
\examples{
data("TaxSEA_test_data")
res <- TaxSEA(taxon_ranks = TaxSEA_test_data)
head(res$All_databases)

# ORA example (toy): treat taxa with positive values as "hits"
hits <- names(TaxSEA_test_data)
res_ora <- TaxSEA(input_taxa = hits, mode = "ora")
head(res_ora$All_databases)

}
