% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrIdentClassifier.R
\name{TrIdentClassifier}
\alias{TrIdentClassifier}
\title{Classify contigs as Prophage-like, Sloping, HighCovNoPattern, and NoPattern}
\usage{
TrIdentClassifier(
  VLPpileup,
  WCpileup,
  windowSize = 1000,
  minBlockSize = 10000,
  maxBlockSize = Inf,
  minContigLength = 30000,
  minSlope = 0.001,
  minSlopeSize = 20000,
  minHCNPRatio = 2,
  VLPReads,
  WCReads,
  verbose = TRUE,
  SaveFilesTo
)
}
\arguments{
\item{VLPpileup}{VLP-fraction pileup file generated by mapping sequencing reads 
from a sample's ultra-purified VLP-fraction mapped to the sample's whole-community
metagenome assembly. The pileup file MUST have the following format:
* V1: Contig accession
* V2: Mapped read coverage values averaged over 100 bp windows
* V3: Starting position (bp) of each 100 bp window. Restarts from 0 at the
start of each new contig.
* V4: Starting position (bp) of each 100 bp window. Does NOT restart at the
start of each new contig.}

\item{WCpileup}{A whole-community pileup file generated by mapping sequencing reads
from a sample's whole-community mapped to the sample's whole-community metagenome assembly.
The pileup file MUST have the following format:
* V1: Contig accession
* V2: Mapped read coverage values averaged over 100 bp windows
* V3: Starting position (bp) of each 100 bp window. Restarts from 0 at the
start of each new contig.
* V4: Starting position (bp) of each 100 bp window. Does NOT restart at the
start of each new contig.}

\item{windowSize}{The number of basepairs to average read coverage values
over. Options are 100, 200, 500, 1000 ONLY.  Default is 1000.}

\item{minBlockSize}{The minimum size (in bp) of the Prophage-like block
pattern. Default is 10000. Must be at least 1000.}

\item{maxBlockSize}{The maximum size (in bp) of the Prophage-like block
pattern. Default is NA (no maximum).}

\item{minContigLength}{The minimum contig size (in bp) to perform
pattern-matching on. Must be at least 25000. Default is 30000.}

\item{minSlope}{The minimum slope value to test for sloping patterns. Default
is 0.001 (i.e minimum change of 10x read coverage over 100,000 bp).}

\item{minSlopeSize}{The minimum width of sloping patterns.Default and 
absolute minimum is 20,000 bp.}

\item{minHCNPRatio}{The minimum VLP:WC ratio value used for HighCovNoPattern 
classifications. Default is 2. (i.e the median VLP-fraction coverage must be
at least 2x the median WC read coverage to be classified as HighCovNoPattern).}

\item{VLPReads}{Optional, the number of VLP-fraction reads used for mapping 
and creation of pileup.}

\item{WCReads}{Optional, the number of WC reads used for mapping and 
creation of pileup.}

\item{verbose}{TRUE or FALSE. Print progress messages to console. Default is TRUE.}

\item{SaveFilesTo}{Optional, Provide a path to the directory you wish to save
output to. A folder will be made within the provided directory to store
results.}
}
\value{
Large list containing 5 objects
}
\description{
Performs all the pattern-matching and summarizes the results into a list. The
first item in the list is a table consisting of the summary information of
all the contigs that passed through pattern-matching (i.e were not filtered
out). The second item in the list is a table consisting of the summary
information of all contigs that were classified via pattern-matching. The
third item in the list contains the pattern-match information associated with
each contig in the previous table. The fourth object in the list is a table
containing the contigs that were filtered out prior to pattern-matching. The
fifth item is the windowSize used for the search.
}
\examples{
data("VLPFractionSamplePileup")
data("WholeCommunitySamplePileup")

TrIdent_results <- TrIdentClassifier(
  VLPpileup = VLPFractionSamplePileup,
  WCpileup = WholeCommunitySamplePileup
)
}
