#' Genome statistics for eukaryotes with complete genome sequence
#'
#' Data from the NCBI Genome Database for eukaryotes with complete genome sequence.
#' The list of organisms were obtained from the KEGG Organisms Database, and
#' taxonomy IDs were obtained from the NCBI Taxonomy Database.
#' 
#' @docType data
#'
#' @name spdata
#'
#' @usage data(spdata)
#'
#' @format An object of class \code{"data.frame"}
#'
#' @keywords datasets
#'
#' @references
#' NCBI Genome Database
#' https://www.ncbi.nlm.nih.gov/genome
#' Accessed: August 15, 2019.
#' 
#' NCBI Taxonomy Database
#' https://www.ncbi.nlm.nih.gov/taxonomy
#' Accessed: August 15, 2019.
#' 
#' KEGG Organisms Database
#' https://www.genome.jp/kegg/catalog/org_list.html
#' Accessed: August 15, 2019.
#'
#' @examples
#' data(spdata)
NULL