% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{UMI4C}
\alias{UMI4C}
\alias{.UMI4C}
\alias{UMI4C-class}
\alias{makeUMI4C}
\title{UMI4C-class}
\usage{
makeUMI4C(
  colData,
  viewpoint_name = "Unknown",
  grouping = "condition",
  normalized = TRUE,
  ref_umi4c = NULL,
  bait_exclusion = 3000,
  bait_expansion = 1e+06,
  scales = 5:150,
  min_win_factor = 0.02,
  sd = 2
)
}
\arguments{
\item{colData}{Data.frame containing the information for constructing the
UMI4C experiment object. Needs to contain the following columns:
\itemize{
    \item sampleID. Unique identifier for the sample.
    \item condition. Condition for performing differential analysis. Can be
    control and treatment, two different cell types, etc.
    \item replicate. Number for identifying replicates.
    \item file. File as outputed by \code{umi4CatsContacts} function.
}}

\item{viewpoint_name}{Character indicating the name for the used viewpoint.}

\item{grouping}{Name of the column in colData used to merge the samples or
replicates. Set to NULL for skipping grouping. Default: "condition".}

\item{normalized}{Logical indicating whether UMI-4C profiles should be
normalized to the \code{ref_umi4c} sample/group. Default: TRUE}

\item{ref_umi4c}{Name of the sample or group to use as reference for
normalization. By default is NULL, which means it will use the sample with
less UMIs in the analyzed region. It should be a named vector, where the name
corresponds to the grouping column from \code{colData} and the value represents
the level to use as reference.}

\item{bait_exclusion}{Region around the bait (in bp) to be excluded from the
analysis. Default: 3000bp.}

\item{bait_expansion}{Number of bp upstream and downstream of the bait to use
for the analysis (region centered in bait). Default: 1Mb.}

\item{scales}{Numeric vector containing the scales for calculating the
domainogram.}

\item{min_win_factor}{Proportion of UMIs that need to be found in a specific
window for adaptative trend calculation}

\item{sd}{Stantard deviation for adaptative trend.}
}
\value{
It returns an object of the class \linkS4class{UMI4C}.
}
\description{
The \linkS4class{UMI4C} constructor is the function \code{\link{makeUMI4C}}. By using
 the arguments listed below, performs the necessary steps to analyze UMI-4C
 data and summarize it in an object of class \linkS4class{UMI4C}.
}
\section{Slots}{

\describe{
\item{\code{colData}}{Data.frame containing the information for constructing the
UMI4C experiment object. Needs to contain the following columns:
\itemize{
    \item \code{sampleID}: Unique identifier for the sample.
    \item \code{condition}: Condition for performing differential analysis.
    Can be control and treatment, two different cell types, etc.
    \item \code{replicate}: Number or ID for identifying different replicates.
    \item \code{file}: Path to the files outputed by \code{\link{contactsUMI4C}}.
}}

\item{\code{rowRanges}}{\link[GenomicRanges]{GRanges-class} object with the coordinates for
the restriction fragment ends, their IDs and other additional annotation columns.}

\item{\code{metadata}}{List containing the following elements:
\enumerate{
    \item \code{bait}: \link[GenomicRanges]{GRanges-class} object representing the position
     of the bait used for the analysis.
    \item \code{scales}: Numeric vector containing the scales used for
    calculating the domainogram.
    \item \code{min_win_factor}: Factor for calculating the minimum molecules
     requiered in a window for not merging it with the next one when
     calculating the adaptative smoothing trend.
    \item \code{grouping}: Columns in \code{colData} used for the different
    sample groupings, accessible through \code{groupsUMI4C}.
    \item \code{normalized}: Logical indicating whether samples/groups are
     normalized or not.
    \item \code{region}: \link[GenomicRanges]{GRanges-class} with the coordinates of
    the genomic window used for analyzing UMI4C data.
    \item \code{ref_umi4c}: Name of the sample or group used as reference for
    normalization.
}}

\item{\code{assays}}{Matrix where each row represents a restriction fragment site
and columns represent each sample or group defined in \code{grouping}.
After running the \code{\link{makeUMI4C}} function, it will contain the
following data:
\enumerate{
    \item \code{umis}: Raw number of UMIs detected by \code{\link{contactsUMI4C}}.
    \item \code{norm_mat}: Normalization factors for each sample/group and fragment end.
    \item \code{trend}: Adaptative smoothing trend of UMIs.
    \item \code{geo_coords}: Geometric coordinates obtained when performing
    the adaptative smoothing.
    \item \code{scale}: Scale selected for the adaptative smoothing.
    \item \code{sd}: Stantard deviation for the adaptative smoothing trend.
}}

\item{\code{dgram}}{List containing the domainograms for each sample. A domainogram
is matrix where columns are different scales selected for merging UMI counts
and rows are the restriction fragments.}

\item{\code{groupsUMI4C}}{List of \code{UMI4C} objects with the specific groupings.}

\item{\code{results}}{List containing the results for the differential analysis ran
using \code{\link{fisherUMI4C}}.}
}}

\note{
The \code{UMI4C} class extends the \link[SummarizedExperiment]{SummarizedExperiment} class.
}
\examples{
# Load sample processed file paths
files <- list.files(system.file("extdata", "CIITA", "count",
    package = "UMI4Cats"
),
pattern = "*_counts.tsv",
full.names = TRUE
)

# Create colData including all relevant information
colData <- data.frame(
    sampleID = gsub("_counts.tsv.gz", "", basename(files)),
    file = files,
    stringsAsFactors = FALSE
)

library(tidyr)
colData <- colData |>
    separate(sampleID,
        into = c("condition", "replicate", "viewpoint"),
        remove = FALSE
    )

# Load UMI-4C data and generate UMI4C object
umi <- makeUMI4C(
    colData = colData,
    viewpoint_name = "CIITA",
    grouping = "condition"
)
}
\seealso{
UMI4C-methods
}
