% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dds2UMI4C}
\alias{dds2UMI4C}
\title{DDS object to UMI4Cats object.}
\usage{
dds2UMI4C(
  umi4c,
  dds,
  normalized = TRUE,
  padj_method = "fdr",
  padj_threshold = 0.05
)
}
\arguments{
\item{umi4c}{UMI4C object as generated by \code{makeUMI4C} or the
\code{UMI4C} constructor.}

\item{dds}{DDS object as generated by \code{nbinomWaldTestUMI4C} 
with the DESeq2 Wald Test results}

\item{normalized}{Logical indicating if the function should return normalized
or raw UMI counts.  Default: TRUE.}

\item{padj_method}{The method to use for adjusting p-values, see
\code{\link[stats]{p.adjust}}.  Default: fdr.}

\item{padj_threshold}{Numeric indicating the adjusted p-value threshold to
use to define significant differential contacts.  Default: 0.05.}
}
\value{
UMI4C object with the DESeq2 Wald Test results.
}
\description{
Transforms an DDS object to a UMI4C object after applying 
\code{nbinomWaldTestUMI4C}.
}
