% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callInteractions.R
\name{zscoreUMI4C}
\alias{zscoreUMI4C}
\title{Z-score calculation using residuals of trend and fit UMI4C counts}
\usage{
zscoreUMI4C(
  dds,
  padj_method = "fdr",
  zscore_threshold = 2,
  padj_threshold = 0.1
)
}
\arguments{
\item{dds}{DDS object as generated by \code{smoothMonotoneUMI4C} with the 
smooth monotone fit counts}

\item{padj_method}{The method to use for adjusting p-values, see
\code{\link[stats]{p.adjust}}.  Default: fdr.}

\item{zscore_threshold}{Numeric indicating the z-score threshold to
use to define significant differential contacts.  Default: 2.}

\item{padj_threshold}{Numeric indicating the adjusted p-value threshold to
use to define significant differential contacts.  Default: 0.1.}
}
\value{
DDS object with zscore,pvalue and padjusted assays
}
\description{
Calculates the z-score and then they are converted into one-sided P-values and 
adjusted for multiple testing using the method of Benjamini and Hochberg
}
\details{
This function calculates the z-score for each fragment over all samples from the residuals of the 
symmetric monotone fit and the median absolute deviation (mad). Z-scores are then converted 
into one-sided P-values using the standard Normal cumulative distribution function, 
and these are adjusted for multiple testing using the method of Benjamini and Hochberg
}
