% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxVDJ.R
\name{boxVDJ}
\alias{boxVDJ}
\alias{boxVDJ,matrix-method}
\title{Create a box plot for diversity measures}
\usage{
boxVDJ(d, ...)

\S4method{boxVDJ}{matrix}(
  d,
  sampleGroups = NULL,
  method = c("shannon", "simpson", "invsimpson", "chao1", "chaobunge"),
  title = NULL,
  legend = FALSE
)
}
\arguments{
\item{d}{A \code{matrix} created with \code{calculateDiversity}.}

\item{...}{additional arguments.}

\item{sampleGroups}{A \code{matrix} or \code{data.frame} that
identifies the groups that each sample belongs to. The matrix must contain
two columns. The first column lists the individual samples and should be
called "Sample". The second column should list the group that each sample
belongs to (e.g. Normal and Tumor) and be called "Group". If no
sampleGroups dataset is provided, all of the samples will be plotted
in one group.}

\item{method}{Identifies the type of diversity that is to be plotted.}

\item{title}{Character vector with an optional title.}

\item{legend}{If TRUE, a legend will be included with the plot. If FALSE,
no legend is included in the plot.}
}
\value{
Returns a \code{ggplot} plot with a box plot that shows the
diversity for each sample. A box plot is created for each of the
grouping variables. The individual diversity measures are
plotted on the box plots.
}
\description{
\code{boxVDJ} creates a box plot of the specified diversity.
}
\examples{
data('contigs')
x <- clonoStats(contigs)
d <- calculateDiversity(x)
sampleGroups <- data.frame(Sample = c("sample1", "sample2"), 
                           Group = c("Cancer", "Normal"))
boxVDJ(d, sampleGroups = sampleGroups, method = "shannon", 
       title = "Shannon diversity", legend = FALSE)

}
