% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-ArrayViews.R,
%   R/methods-SnpArrayExperiment.R
\name{isHeterozygous}
\alias{isHeterozygous}
\alias{isHeterozygous,ArrayViews-method}
\alias{isHeterozygous,SnpArrayExperiment-method}
\alias{isHeterozygous,numeric-method}
\alias{isHeterozygous,matrix-method}
\title{Assess whether genotype is heterozygous based on BAFs}
\usage{
isHeterozygous(object, cutoff)

\S4method{isHeterozygous}{ArrayViews}(object, cutoff)

\S4method{isHeterozygous}{SnpArrayExperiment}(object, cutoff)

\S4method{isHeterozygous}{numeric}(object, cutoff)

\S4method{isHeterozygous}{matrix}(object, cutoff)
}
\arguments{
\item{object}{a SnpArrayExperiment or ArrayViews object containing
BAFs, a matrix of BAFs, or a numeric vector of BAFs.
vector of BAFs}

\item{cutoff}{a length-two numeric vector providing the range of
BAFs consistent with allelic  heterozygosity}
}
\description{
Assess whether genotype is heterozygous based on BAFs
}
\examples{
if(require("BSgenome.Hsapiens.UCSC.hg18")){
  bsgenome <- BSgenome.Hsapiens.UCSC.hg18
  snp_exp <- getExampleSnpExperiment(bsgenome)
  is_het <- isHeterozygous(snp_exp[, 1], c(0.4, 0.6))
  table(is_het)
}
}
