% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_heatmap.R
\name{show_heatmap}
\alias{show_heatmap}
\alias{show_heatmap,GO_clusters,character-method}
\title{Display an interactive or static heatmap.}
\usage{
show_heatmap(
  object,
  type,
  file = NULL,
  plotly_update = FALSE,
  height = 1000,
  width = 800
)

\S4method{show_heatmap}{GO_clusters,character}(
  object,
  type,
  file = NULL,
  plotly_update = FALSE,
  height = 1000,
  width = 800
)
}
\arguments{
\item{object}{a \code{\link{GO_clusters-class}} object from \code{\link{GOterms_heatmap}} or \code{\link{GOclusters_heatmap}}.}

\item{type}{could be "GOterms" to display GOterms clustering heatmap, or "GOclusters" to display GOclusters heatmap.}

\item{file}{static png output file name (default to NULL).}

\item{plotly_update}{update plotly html dependencies (default to FALSE).}

\item{height}{static image height (default to 1000).}

\item{width}{static image width (default to 1000).}
}
\value{
display or print heatmap.
}
\description{
Display a heatmap in interactive or static mode.
}
\details{
This method displays an interactive heatmap (if \code{file}=NULL) from \code{\link{GO_clusters-class}} object for "GOterms" or "GOclusters" type.\cr
A static png image could be printed by setting \code{file} argument.\cr
Interactive heatmap cannot be displayed between two R versions.
Then interactive view (build with previous R version) can be updated to new R version using \code{plotly_update} argument setting to TRUE.
}
\examples{
# load data example
data(
    myGOs,
    package="ViSEAGO"
)
\dontrun{
# compute GO terms Semantic Similarity distances
myGOs<-ViSEAGO::compute_SS_distances(
    myGOs,
    distance="Wang"
)

# build MDS plot for a GO_SS-class distance object
ViSEAGO::MDSplot(myGOs)

# GOtermsHeatmap with default parameters
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2",
            rotate=NULL
        ),
        cut=list(
            dynamic=list(
                pamStage=TRUE,
                pamRespectsDendro=TRUE,
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Display GO terms heatmap
ViSEAGO::show_heatmap(
    Wang_clusters_wardD2,
    "GOterms"
)

# Print GO terms heatmap
ViSEAGO::show_heatmap(
    Wang_clusters_wardD2,
    "GOterms",
    "GOterms_heatmap.png"
)

# compute clusters of GO terms Semantic Similarity distances
Wang_clusters_wardD2<-ViSEAGO::compute_SS_distances(
    Wang_clusters_wardD2,
    distance="BMA"
)

# GOclusters heatmap
Wang_clusters_wardD2<-ViSEAGO::GOclusters_heatmap(
    Wang_clusters_wardD2,
    tree=list(
        distance="BMA",
        aggreg.method="ward.D2",
        rotate=NULL
    )
)

# Display GO clusters heatmap
ViSEAGO::show_heatmap(
    Wang_clusters_wardD2,
    "GOclusters"
)

# Print GO clusters heatmap
ViSEAGO::show_heatmap(
    Wang_clusters_wardD2,
    "GOclusters",
    "GOclusters_heatmap.png"
)
}
}
\seealso{
Other enrich_GO_terms: 
\code{\link{Upset}()},
\code{\link{enrich_GO_terms-class}},
\code{\link{overLapper}()},
\code{\link{show_table}()}

Other GO_clusters: 
\code{\link{GO_clusters-class}},
\code{\link{GOclusters_heatmap}()},
\code{\link{clusters_cor}()},
\code{\link{compare_clusters}()},
\code{\link{show_table}()}

Other visualization: 
\code{\link{GOclusters_heatmap}()},
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{Upset}()},
\code{\link{available_organisms}()},
\code{\link{overLapper}()},
\code{\link{show_table}()}
}
\concept{GO_clusters}
\concept{enrich_GO_terms}
\concept{visualization}
