% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxSpatialList-class.R
\docType{class}
\name{TENxSpatialList-class}
\alias{TENxSpatialList-class}
\alias{.TENxSpatialList}
\alias{TENxSpatialList}
\alias{import,TENxSpatialList,ANY,ANY-method}
\title{A class to represent and import spatial Visium data}
\usage{
TENxSpatialList(
  resources,
  sample_id = "sample01",
  images = c("lowres", "hires", "detected", "aligned", "aligned_fiducials", "cytassist"),
  jsonFile = .SCALE_JSON_FILE,
  tissuePattern = "tissue_positions.*",
  bin_size = character(0L),
  ...
)

\S4method{import}{TENxSpatialList,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{resources}{A \link[TENxIO:TENxFileList-class]{TENxFileList} object or a
file path to the tarball containing the matrix / assay data resources.}

\item{sample_id}{\code{character(1)} A single string specifying the sample ID.}

\item{images}{\code{character()} A vector specifying the images to be imported;
can be one or multiple of "lowres", "hires", "detected", "aligned".}

\item{jsonFile}{\code{character(1)} A single string specifying the name of the
JSON file containing the scale factors.}

\item{tissuePattern}{\code{character(1)} A single string specifying the pattern
to match the tissue positions file.}

\item{bin_size}{\code{character(1)} The bin size of the images to import. The
default is \code{008}. It corresponds to the directory name \code{square_000um} where
\code{000} is the bin value.}

\item{...}{Parameters to pass to the format-specific method.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}
}
\value{
A \code{SpatialExperiment} object
}
\description{
This class is a composed class of
\link[TENxIO:TENxFileList-class]{TENxFileList}, which can contain a list of
\link[TENxIO:TENxFile-class]{TENxFile} objects, and a \link{TENxSpatialList} object.
It is meant to handle spatial Visium data from 10X Genomics.
}
\details{
Typically, the user will not create an object of this class directly
but rather use the \code{\link[=TENxVisium]{TENxVisium()}} constructor function to create an object
of this class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{import(con = TENxSpatialList, format = ANY, text = ANY)}: Import a \code{TENxSpatialList} object

}}
\section{Slots}{

\describe{
\item{\code{images}}{\code{character()} The image name(s) to use with \code{grep} and include
in the list of files. Can be one of "lowres", "hires",  "lowres", "hires",
"detected", "aligned", "aligned_fiducials", or "cytassist".}

\item{\code{scaleJSON}}{\code{character(1)} The file name of the scale factors JSON file,
defaults to 'scalefactors_json.json'.}

\item{\code{tissuePos}}{\code{character(1)} The file name of the tissue positions file;
typically a \code{.parquet} or \code{.csv} file.}

\item{\code{sampleId}}{\code{character(1)} A scalar specifying the sample identifier.}

\item{\code{binSize}}{The bin size of the images to import. The default slot value is
\code{character()}. It typically corresponds to the directory name
\code{square_000um} where \code{000} is the bin value.}
}}

\examples{
spatial_dir <- system.file(
    file.path("extdata", "10xVisium", "section1", "outs", "spatial"),
    package = "VisiumIO"
)

TENxSpatialList(resources = spatial_dir, images = "lowres")

TENxSpatialList(resources = spatial_dir, images = "lowres") |>
    metadata() |> lapply(names)

}
