% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxGeoJSON.R
\docType{class}
\name{TENxGeoJSON-class}
\alias{TENxGeoJSON-class}
\alias{.TENxGeoJSON}
\alias{TENxGeoJSON}
\alias{import,TENxGeoJSON,ANY,ANY-method}
\title{Import 10X Genomics GeoJSON files}
\usage{
TENxGeoJSON(resource)

\S4method{import}{TENxGeoJSON,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{resource}{character(1) The path to the file}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{...}{Additional inputs to the low level class generator functions}
}
\value{
\code{TENxGeoJSON()}: An object of class \link{TENxGeoJSON}

import-method: An \code{sf} and \code{data.frame} with the GeoJSON data
}
\description{
\code{TENxGeoJSON} is a class to represent and import GeoJSON files
from 10X Genomics. It is a composed class of \link[TENxIO:TENxFile]{TENxIO::TENxFile}.
}
\details{
Typically, the user will not create an object of this class directly
but rather use the \code{\link[=TENxVisium]{TENxVisium()}} constructor function to create an object
of this class in the background.
}
\examples{
segout_folder <- system.file(
    file.path("extdata", "segmented_outputs"),
    package = "VisiumIO"
)

## import cell boundaries
cellsegs <- file.path(segout_folder, "cell_segmentations.geojson")

TENxGeoJSON(cellsegs)

TENxGeoJSON(cellsegs) |>
    import()

## import nucleus boundaries
nucsegs <- file.path(segout_folder, "nucleus_segmentations.geojson")

TENxGeoJSON(nucsegs) |>
    import()
}
\seealso{
\url{https://www.10xgenomics.com/support/software/xenium-ranger/3.0/analysis/segmentation-inputs}
}
