% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{getDivergeRange}
\alias{getDivergeRange}
\title{Get beginning and end of palette to center a divergent palette}
\usage{
getDivergeRange(values, diverge_center = 0)
}
\arguments{
\item{values}{Numeric vector to be colored.}

\item{diverge_center}{Value to center on, defaults to 0.}
}
\value{
A numeric vector of length 2, the first element is for beginning, and
the second for end. The values are between 0 and 1.
}
\description{
This function is no longer used internally as it's unnecessary for
\code{scico} divergent palettes. But it can be useful when using divergent
palettes outside \code{scico} where one must specify beginning and end but
not midpoint, to override the default palette.
}
\examples{
v <- rnorm(10)
getDivergeRange(v, diverge_center = 0)
}
