% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleosome_enrichment.R
\name{computeNucleosomeEnrichmentOverBackground}
\alias{computeNucleosomeEnrichmentOverBackground}
\title{Internal function}
\usage{
computeNucleosomeEnrichmentOverBackground(
  Vmat,
  background = NULL,
  plus1_nuc_only = FALSE,
  minus1_nuc = list(c(xmin = -150, xmax = -70), c(ymin = 165, ymax = 260)),
  minus1_nuc_neg = list(c(xmin = -150, xmax = -70), c(ymin = 60, ymax = 145)),
  plus1_nuc = list(c(xmin = 70, xmax = 150), c(ymin = 165, ymax = 260)),
  plus1_nuc_neg = list(c(xmin = 70, xmax = 150), c(ymin = 50, ymax = 145)),
  ...
)
}
\arguments{
\item{Vmat}{A Vmat computed by nucleosomeEnrichment function}

\item{background}{a background Vmat}

\item{plus1_nuc_only}{Boolean Should compute nucleosome enrichment
only for +1 nucleosome?}

\item{minus1_nuc}{list where the -1 nucleosome is located}

\item{minus1_nuc_neg}{where the background of the -1 nucleosome 
is located}

\item{plus1_nuc}{where the +1 nucleosome is located}

\item{plus1_nuc_neg}{where the background of the +1 nucleosome
is located}

\item{...}{additional parameters}
}
\value{
list
}
\description{
A function to compute nucleosome enrichment of a Vmat
}
\keyword{internal}
